<?php
class General_masters_model extends Crud_model
{
	//Select country
	public function get_countries($entered_str)
	{
		$json_data 		=	array(0=>array('id'=>'','text'=>"Select Country"));
		$condition		=	array();
		if($entered_str) 
			$condition["name LIKE "] = "%$entered_str%";
		$drpdwn_data	=	$this->select_data(COUNTRY_TBL,$select='country_id,name',$condition, 0, array(),'sortname',"ASC",'', 0, null);
		$i=1;
		foreach($drpdwn_data as $row)
		{
			$json_data[$i]['id']	=	$row['country_id'];
			$json_data[$i]['text']  = 	$row['name'];
			$i++;
		}	
		$data['results'] = $json_data;
		return json_encode($data);
	}
	//Select state on change of country
	public function get_state_by_country($entered_str,$country_id)
	{
		$json_data 		=	array(0=>array('id'=>'','text'=>"Select State"));
		$condition		=	array();
		if($country_id)
			$condition["country_id"] = $country_id;
		if($entered_str) 
			$condition["state LIKE "] = "%$entered_str%";
		$drpdwn_data   	=	$this->select_data(STATE_TBL,$select='state_id,state',$condition,0, array(),'state',"ASC",'', 0, null);
		$i=1;
		foreach($drpdwn_data as $row)
		{
			$json_data[$i]['id']	=	$row['state_id'];
			$json_data[$i]['text']  = 	$row['state'];
			$i++;
		}	
		$data['results'] = $json_data;
		return json_encode($data);
	}
	//Select company
	public function get_company($entered_str)
	{
		$json_data 		=	array(0=>array('id'=>'','text'=>"Select Company"));
		$condition		=	array();
		if($entered_str) 
			$condition["cmp_name LIKE "] = "%$entered_str%";
		$drpdwn_data	=	$this->select_data(COMPANY_TBL,$select='cmp_id,cmp_name',$condition, 0, array(),'cmp_name',"ASC",'', 0, null);
		$i=1;
		foreach($drpdwn_data as $row)
		{
			$json_data[$i]['id']	=	$row['cmp_id'];
			$json_data[$i]['text']  = 	$row['cmp_name'];
			$i++;
		}	
		$data['results'] = $json_data;
		return json_encode($data);
	}
	//Select branch
	public function get_branch($entered_str,$company_id)
	{
		$json_data 		=	array(0=>array('id'=>'','text'=>"Select Branch"));
		$condition		=	array();
		if($company_id)
			$condition["branch_cmp_id"] = $company_id;
		if($entered_str) 
			$condition["branch_name LIKE "] = "%$entered_str%";
		$drpdwn_data   	=	$this->select_data(BRANCH_TBL,$select='branch_id,branch_name',$condition,0, array(),'branch_name',"ASC",'', 0, null);
		$i=1;
		foreach($drpdwn_data as $row)
		{
			$json_data[$i]['id']	=	$row['branch_id'];
			$json_data[$i]['text']  = 	$row['branch_name'];
			$i++;
		}	
		$data['results'] = $json_data;
		return json_encode($data);
	}

	public function get_port_of_dis($entered_str)
	{
		$json_data 		=	array(0=>array('id'=>'','text'=>"Select Port Name"));
		$condition		=	array();
		if($entered_str) 
			$condition["port_of_dis_name LIKE "] = "%$entered_str%";
		$drpdwn_data	=	$this->select_data(PORT_TBL,$select='port_of_dis_id,port_of_dis_name',$condition, 0, array(),'port_of_dis_name',"ASC",'', 0, null);
		$i=1;
		foreach($drpdwn_data as $row)
		{
			$json_data[$i]['id']	=	$row['port_of_dis_id'];
			$json_data[$i]['text']  = 	$row['port_of_dis_name'];
			$i++;
		}	
		$data['results'] = $json_data;
		return json_encode($data);
	}

	//Select designation
	public function get_designation($entered_str)
	{
		$json_data 		=	array(0=>array('id'=>'','text'=>"Select Designation"));
		$condition		=	array();
		if($entered_str) 
			$condition["desig_name LIKE "] = "%$entered_str%";
		$drpdwn_data	=	$this->select_data(DESIGNATION_TBL,$select='desig_id,desig_name',$condition, 0, array(),'desig_name',"ASC",'', 0, null);
		$i=1;
		foreach($drpdwn_data as $row)
		{
			$json_data[$i]['id']	=	$row['desig_id'];
			$json_data[$i]['text']  = 	$row['desig_name'];
			$i++;
		}	
		$data['results'] = $json_data;
		return json_encode($data);
	}
	//Select currency
	public function get_currency($entered_str)
	{
		$json_data 		=	array(0=>array('id'=>'','text'=>"Select Currency"));
		$condition		=	array();
		if($entered_str) 
			$condition["currency LIKE "] = "%$entered_str%";
		$drpdwn_data	=	$this->select_data(CURRENCY_TBL,$select='currency_id,currency,currency_code',$condition, 0, array(),'currency',"ASC",'', 0, null);
		$i=1;
		foreach($drpdwn_data as $row)
		{
			$json_data[$i]['id']	=	$row['currency_id'];
			$json_data[$i]['text']  = 	$row['currency'].'('.$row['currency_code'].')';
			$i++;
		}	
		$data['results'] = $json_data;
		return json_encode($data);
	}
	//Select employee
	public function get_employee($entered_str,$company_id,$branch_id,$desig_id)
	{
		$json_data 		=	array(0=>array('id'=>'','text'=>"Select Employee"));
		$condition		=	array();
		if($company_id)
			$condition["emp_cmp_id"] = $company_id;
		if($branch_id)
			$condition["emp_branch_id"] = $branch_id;
		if($desig_id)
			$condition["emp_desig_id"] = $desig_id;
		if($entered_str) 
			$condition["emp_name LIKE "] = "%$entered_str%";
		$drpdwn_data   	=	$this->select_data(EMPLOYEE_TBL,'*',$condition,0, array(),'emp_name',"ASC",'', 0, null);
		$i=1;
		foreach($drpdwn_data as $row)
		{
			$json_data[$i]['id']	=	$row['emp_id'];
			$json_data[$i]['text']  = 	$row['emp_name'];
			$i++;
		}	
		$data['results'] = $json_data;
		return json_encode($data);
	}	
	//Select facory
	public function get_factory($entered_str,$company_id)
	{
		$json_data 		=	array(0=>array('id'=>'','text'=>"Select Factory"));
		$condition		=	array();
		if($company_id)
			$condition["factory_cmp_id"] = $company_id;
		if($entered_str) 
			$condition["factory_name LIKE "] = "%$entered_str%";
		$drpdwn_data   	=	$this->select_data(FACTORY_TBL,$select='factory_id,factory_name',$condition,0, array(),'factory_name',"ASC",'', 0, null);
		$i=1;
		foreach($drpdwn_data as $row)
		{
			$json_data[$i]['id']	=	$row['factory_id'];
			$json_data[$i]['text']  = 	$row['factory_name'];
			$i++;
		}	
		$data['results'] = $json_data;
		return json_encode($data);
	}
	//Select client
	public function get_client($entered_str,$company_id,$branch_id)
	{
		$json_data 		=	array(0=>array('id'=>'','text'=>"Select Client"));
		$condition		=	array();
		if($company_id)
			$condition["clnt_company_id"] = $company_id;
		if($branch_id)
			$condition["clnt_branch_id"] = $branch_id;
		if($entered_str) 
			$condition["clnt_name LIKE "] = "%$entered_str%";
		$drpdwn_data   	=	$this->select_data(CLIENT_TBL,'*',$condition,0, array(),'clnt_name',"ASC",'', 0, null);
		$i=1;
		foreach($drpdwn_data as $row)
		{
			$json_data[$i]['id']	=	$row['clnt_id'];
			$json_data[$i]['text']  = 	$row['clnt_name'];
			$i++;
		}	
		$data['results'] = $json_data;
		return json_encode($data);
	}	
	//Select agent
	public function get_agent($entered_str,$company_id,$branch_id)
	{
		$json_data 		=	array(0=>array('id'=>'','text'=>"Select Agent"));
		$condition		=	array();
		if($company_id)
			$condition["agent_cmp_id"] = $company_id;
		if($branch_id)
			$condition["agent_branch_id"] = $branch_id;
		if($entered_str) 
			$condition["agent_name LIKE "] = "%$entered_str%";
		$drpdwn_data   	=	$this->select_data(AGENT_TBL,'*',$condition,0, array(),'agent_name',"ASC",'', 0, null);
		$i=1;
		foreach($drpdwn_data as $row)
		{
			$json_data[$i]['id']	=	$row['agent_id'];
			$json_data[$i]['text']  = 	$row['agent_name'];
			$i++;
		}	
		$data['results'] = $json_data;
		return json_encode($data);
	}	
	
	
	public function get_ledgergroup()
	{
		 	
		 
			$this->db->select("A.ledger_group_id,A.ledger_group_name,A.parent_id,B.ledger_group_name as parent");
			$this->db->from('ledgergroup A');
			$this->db->join('ledgergroup B','A.parent_id = B.ledger_group_id','left');
			 
			$result  = $this->db->get();
			  // $this->db->last_query();
			 
			 
			 return  $result->result_array() ;
			
	 
	}

	public function get_consignor()
	{
		 	
		 
			$this->db->select("consignor_id,consignor_name,consignor_con_person,consignor_con_no");
			$this->db->from('consignor');
			
			 
			$result  = $this->db->get();
			  // $this->db->last_query();
			 
			 
			 return  $result->result_array() ;
			
	 
	}

	public function get_consignee()
	{
		 	
		 
			$this->db->select("consignee_id,consignee_name,consignee_con_person,consignee_con_no");
			$this->db->from('consignee');
			
			 
			$result  = $this->db->get();
			  // $this->db->last_query();
			 
			 
			 return  $result->result_array() ;
			
	 
	}
 public function get_prefix()
	{
		 	
		 
			$this->db->select("prefix_id,prefix_name,prefix_company_id,starting_no,current_no,prefix_branch_id,company.cmp_name,branch.branch_name");
			$this->db->join('company','company.cmp_id=prefix_master.prefix_company_id','left');
			$this->db->join('branch','branch.branch_id=prefix_master.prefix_branch_id','left');
			$this->db->from('prefix_master');
			
			 
			$result  = $this->db->get();
			  // $this->db->last_query();
			 
			 
			 return  $result->result_array() ;
			
	 
	}
	public function get_notify()
	{
		 	
		 
			$this->db->select("notify_id,notify_name,notify_con_person,notify_con_no");
			$this->db->from('notify');
			
			 
			$result  = $this->db->get();
			  // $this->db->last_query();
			 
			 
			 return  $result->result_array() ;
			
	 
	}
	
	


public function get_consignorlist($condition)
	{
		 	
		 
			$this->db->select("consignor_id,consignor_name,consignor_con_no,consignor_con_person");
			$this->db->from('consignor');
			
			if($condition != "")
			{
			$this->db->where('consignor_id',$condition);
				} 
			$result  = $this->db->get();
			  // $this->db->last_query();
			 
			 
			 return  $result->result_array() ;
			
	 
	}

	public function get_consigneelist($condition)
	{
		 	
		 
			$this->db->select("consignee_id,consignee_name,consignee_con_no,consignee_con_person");
			$this->db->from('consignee');
			
			if($condition != "")
			{
			$this->db->where('consignee_id',$condition);
				} 
			$result  = $this->db->get();
			  // $this->db->last_query();
			 
			 
			 return  $result->result_array() ;
			
	 
	}

	public function get_notifylist($condition)
	{
		 	
		 
			$this->db->select("notify_id,notify_name,notify_con_no,notify_con_person");
			$this->db->from('notify');
			
			if($condition != "")
			{
			$this->db->where('notify_id',$condition);
				} 
			$result  = $this->db->get();
			  // $this->db->last_query();
			 
			 
			 return  $result->result_array() ;
			
	 
	}
	
	
	public function get_banklist($condition)
	{
		 	
		 
			$this->db->select("A.*");
			$this->db->from('bank A');
			//$this->db->join('ledgergroup B','A.parent_id = B.ledger_group_id','left');
			if($condition != "")
			{
			$this->db->where('A.bank_id',$condition);
				} 
			$result  = $this->db->get();
			  // $this->db->last_query();
			 
			 
			 return  $result->result_array() ;
			
	 
	}
	
	
	
	
	//get_ledgergrouplist
	public function get_ledger_list($condition,$ledger_group_id)
	{
		 	
		 
			$this->db->select("A.*,B.ledger_group_name as parent,C.cmp_name as companyname,D.branch_name as branch_name");
			$this->db->from('ledger A');
			$this->db->join('ledgergroup B','A.parent_ledger_group_id = B.ledger_group_id','left');
			$this->db->join('company C','A.ledger_company_id = C.cmp_id','left');
			$this->db->join('branch D','A.ledger_branch_id = D.branch_id','left');
			if($condition != "")
			{
			$this->db->where('A.ledger_master_id',$condition);
				} 
				if($ledger_group_id != "")
			{
			$this->db->where('A.parent_ledger_group_id',$ledger_group_id);
				} 
			$result  = $this->db->get();
			  // $this->db->last_query();
			 
			 
			 return  $result->result_array() ;
			
	 
	}
	
	


	public function get_consignorsearch($entered_str,$id)
	{
	     
			$this->db->select("consignor_id,consignor_name");
			$this->db->from('consignor');
			
			if($entered_str !='' )
			{
			$this->db->where("consignor_name LIKE  '%$entered_str%'");
			}
			if($id!='')
			{
			$this->db->where("consignor_id",$id);
			}
				 
			$result  = $this->db->get();
			//echo $this->db->last_query();
        $jsonarray = array('0'=>"Select Shipper/Exporter");
        $i =1;  
			 
			 foreach($result->result_array() as $row)
			{
				     $jsonarray[$row['consignor_id']]       = $row['consignor_name'];
					$i++;
				}
				//$data['result'] =  $jsonarray ;
				return json_encode($this->select2format($jsonarray));
			
	 
	}
	
	public function get_consigneesearch($entered_str,$id)
	{
	     
			$this->db->select("consignee_id,consignee_name");
			$this->db->from('consignee');
			
			if($entered_str !='' )
			{
			$this->db->where("consignee_name LIKE  '%$entered_str%'");
			}
			if($id!='')
			{
			$this->db->where("consignee_id",$id);
			}
				 
			$result  = $this->db->get();
			//echo $this->db->last_query();
        $jsonarray = array('0'=>"Select Consignee Group");
        $i =1;  
			 
			 foreach($result->result_array() as $row)
			{
				     $jsonarray[$row['consignee_id']]       = $row['consignee_name'];
					$i++;
				}
				//$data['result'] =  $jsonarray ;
				return json_encode($this->select2format($jsonarray));
			
	 
	}

	public function get_customersearch($entered_str,$id)
	{
	     
			$this->db->select("customer_id,customer_name");
			$this->db->from('customer');
			
			if($entered_str !='' )
			{
			$this->db->where("customer_name LIKE  '%$entered_str%'");
			}
			if($id!='')
			{
			$this->db->where("customer_id",$id);
			}
				 
			$result  = $this->db->get();
			//echo $this->db->last_query();
        $jsonarray = array('0'=>"Select Customer Group");
        $i =1;  
			 
			 foreach($result->result_array() as $row)
			{
				     $jsonarray[$row['customer_id']]       = $row['customer_name'];
					$i++;
				}
				//$data['result'] =  $jsonarray ;
				return json_encode($this->select2format($jsonarray));
			
	 
	}

	public function get_notifysearch($entered_str,$id)
	{
	     
			$this->db->select("notify_id,notify_name");
			$this->db->from('notify');
			
			if($entered_str !='' )
			{
			$this->db->where("notify_name LIKE  '%$entered_str%'");
			}
			if($id!='')
			{
			$this->db->where("notify_id",$id);
			}
				 
			$result  = $this->db->get();
			//echo $this->db->last_query();
        $jsonarray = array('0'=>"Select Notify Group");
        $i =1;  
			 
			 foreach($result->result_array() as $row)
			{
				     $jsonarray[$row['notify_id']]       = $row['notify_name'];
					$i++;
				}
				//$data['result'] =  $jsonarray ;
				return json_encode($this->select2format($jsonarray));
			
	 
	}
	
	
	
	
		public function get_ledger()
	{
		 	
		 
	        $this->db->select("A.*,B.ledger_group_name as parent,C.cmp_name as companyname,D.branch_name as branch_name");
			$this->db->from('ledger A');
			$this->db->join('ledgergroup B','A.parent_ledger_group_id = B.ledger_group_id','left');
			$this->db->join('company C','A.ledger_company_id = C.cmp_id','left');
			$this->db->join('branch D','A.ledger_branch_id = D.branch_id','left');
 			 
			$result  = $this->db->get();
			  // $this->db->last_query();
			 
			 
			 return  $result->result_array() ;
			
	 
	}
	
	
	

	
		public function get_ledgersearch($entered_str,$id,$ledger_group_id)
	{
	     
			$this->db->select("A.*");
			$this->db->from('ledger A');
			$this->db->where("A.ledger_name LIKE  '%$entered_str%'");
			if($entered_str !='' )
			{
			$this->db->where("A.ledger_name LIKE  '%$entered_str%'");
			}
			if($id!='')
			{
			$this->db->where("A.ledger_master_id",$id);
 			}
			
			if($ledger_group_id !=0)
			{
			$this->db->where("A.parent_ledger_group_id",$ledger_group_id);
			}
			
 			$result  = $this->db->get();
			 
 			 
         	$jsonarray = array('0'=>"Select Ledger ");
        $i =1;  
			 foreach($result->result_array() as $row)
			    {
				     $jsonarray[$row['ledger_master_id']]       = $row['ledger_name'];
					$i++;
				}
				//$data['result'] =  $jsonarray ;
				return json_encode($this->select2format($jsonarray));
 	}
	
	 
	
	public function select2format( $con )
	{
		$i=0;
		$data = $val = array();
		foreach ($con as $key => $value) {
			if (!empty($value)) {
				$val[$i]['id'] 	 = $key;
				$val[$i]['text'] = $value;
				$i++;
			}			
		}
		$data['results'] = $val;
		return $data;
	}
	
	
 	 	public function get_taxclass(){

 		$result = $this->db->query("SELECT A.tax_type,A.id FROM " .acc_tax_type. " A WHERE 1=1");

        $jsonarray = array('0'=>"Select TAX Type ");
        $i         = 1;  
		foreach($result->result_array() as $row)
	    {

			$jsonarray[$row['id']]       = $row['tax_type'];
			$i++;
		}
		

		return json_encode($this->select2format($jsonarray));	
 	}	


 		public function get_productlist($condition)
	{
		 	
		 
			$this->db->select("P.id,product,description,price,hsn_sac,taxType,tax_type");
			$this->db->from('acc_product P');
			$this->db->join('acc_tax_type T','T.id = P.taxType','left');
			
			if($condition != "")
			{
			$this->db->where('P.id',$condition);
				} 
			$result  = $this->db->get();
			 // echo  $this->db->last_query(); exit;
			 
			 
			 return  $result->result_array() ;
			
	 
	}

		public function get_pdtTax($prod_id)
    {
		
		$this->db->select("p.*,c.*");
		$this->db->where('product_id',$prod_id);
		$this->db->where('p.status',0);
		$this->db->join("acc_tax_master c","c.id=p.tax_id AND p.status = 0","left");
		
		$this->db->group_by('tax_id');
		$result = $this->db->get('acc_product_tax_details p');	
        // echo  $this->db->last_query(); exit;
		return $result->result_array();

    } 

	public function get_customerlist($condition)
	{
		 	
		 
			$this->db->select("customer_id,customer_name,customer_con_no,customer_con_person");
			$this->db->from('customer');
			
			if($condition != "")
			{
			$this->db->where('customer_id',$condition);
				} 
			$result  = $this->db->get();
			  // $this->db->last_query();
			 
			 
			 return  $result->result_array() ;
			
	 
	}

	
}