<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
|--------------------------------------------------------------------------
| Display Debug backtrace
|--------------------------------------------------------------------------
|
| If set to TRUE, a backtrace will be displayed along with php errors. If
| error_reporting is disabled, the backtrace will not display, regardless
| of this setting
|
*/
defined('SHOW_DEBUG_BACKTRACE') OR define('SHOW_DEBUG_BACKTRACE', TRUE);

/*
|--------------------------------------------------------------------------
| File and Directory Modes
|--------------------------------------------------------------------------
|
| These prefs are used when checking and setting modes when working
| with the file system.  The defaults are fine on servers with proper
| security, but you may wish (or even need) to change the values in
| certain environments (Apache running a separate process for each
| user, PHP under CGI with Apache suEXEC, etc.).  Octal values should
| always be used to set the mode correctly.
|
*/
defined('FILE_READ_MODE')  OR define('FILE_READ_MODE', 0644);
defined('FILE_WRITE_MODE') OR define('FILE_WRITE_MODE', 0666);
defined('DIR_READ_MODE')   OR define('DIR_READ_MODE', 0755);
defined('DIR_WRITE_MODE')  OR define('DIR_WRITE_MODE', 0755);

/*
|--------------------------------------------------------------------------
| File Stream Modes
|--------------------------------------------------------------------------
|
| These modes are used when working with fopen()/popen()
|
*/
defined('FOPEN_READ')                           OR define('FOPEN_READ', 'rb');
defined('FOPEN_READ_WRITE')                     OR define('FOPEN_READ_WRITE', 'r+b');
defined('FOPEN_WRITE_CREATE_DESTRUCTIVE')       OR define('FOPEN_WRITE_CREATE_DESTRUCTIVE', 'wb'); // truncates existing file data, use with care
defined('FOPEN_READ_WRITE_CREATE_DESTRUCTIVE')  OR define('FOPEN_READ_WRITE_CREATE_DESTRUCTIVE', 'w+b'); // truncates existing file data, use with care
defined('FOPEN_WRITE_CREATE')                   OR define('FOPEN_WRITE_CREATE', 'ab');
defined('FOPEN_READ_WRITE_CREATE')              OR define('FOPEN_READ_WRITE_CREATE', 'a+b');
defined('FOPEN_WRITE_CREATE_STRICT')            OR define('FOPEN_WRITE_CREATE_STRICT', 'xb');
defined('FOPEN_READ_WRITE_CREATE_STRICT')       OR define('FOPEN_READ_WRITE_CREATE_STRICT', 'x+b');

/*
|--------------------------------------------------------------------------
| Exit Status Codes
|--------------------------------------------------------------------------
|
| Used to indicate the conditions under which the script is exit()ing.
| While there is no universal standard for error codes, there are some
| broad conventions.  Three such conventions are mentioned below, for
| those who wish to make use of them.  The CodeIgniter defaults were
| chosen for the least overlap with these conventions, while still
| leaving room for others to be defined in future versions and user
| applications.
|
| The three main conventions used for determining exit status codes
| are as follows:
|
|    Standard C/C++ Library (stdlibc):
|       http://www.gnu.org/software/libc/manual/html_node/Exit-Status.html
|       (This link also contains other GNU-specific conventions)
|    BSD sysexits.h:
|       http://www.gsp.com/cgi-bin/man.cgi?section=3&topic=sysexits
|    Bash scripting:
|       http://tldp.org/LDP/abs/html/exitcodes.html
|
*/
defined('EXIT_SUCCESS')        OR define('EXIT_SUCCESS', 0); // no errors
defined('EXIT_ERROR')          OR define('EXIT_ERROR', 1); // generic error
defined('EXIT_CONFIG')         OR define('EXIT_CONFIG', 3); // configuration error
defined('EXIT_UNKNOWN_FILE')   OR define('EXIT_UNKNOWN_FILE', 4); // file not found
defined('EXIT_UNKNOWN_CLASS')  OR define('EXIT_UNKNOWN_CLASS', 5); // unknown class
defined('EXIT_UNKNOWN_METHOD') OR define('EXIT_UNKNOWN_METHOD', 6); // unknown class member
defined('EXIT_USER_INPUT')     OR define('EXIT_USER_INPUT', 7); // invalid user input
defined('EXIT_DATABASE')       OR define('EXIT_DATABASE', 8); // database error
defined('EXIT__AUTO_MIN')      OR define('EXIT__AUTO_MIN', 9); // lowest automatically-assigned error code
defined('EXIT__AUTO_MAX')      OR define('EXIT__AUTO_MAX', 125); // highest automatically-assigned error code



/*-----------------User constants-----------------*/
define('COMPANY_TITLE', 				'Accounts New');
define('GATHERING',						'1');
define('POLES',							'2');
define('SHEER',							'3');
define('TRACKS',						'4');
define('FABRICS',						'5');
define('PELMETS',						'6');
define('ACCESSORIES',					'7');
define('LINING',						'8');
define('PRODUCT',						'9');
define('PRODUCT_SUBTYPE',				'10');
define('PRODUCT_MAPPING',				'11');

define('CURTAIN',                       '1');
define('ROMAN_BLINDS',                  '2');
define('BLINDS',                  		'3');
define('WSR',							'1');//ID of Whole Sale Rate entry in wp_product_rate table
define('RR',							'2');//ID of Retail Rate entry in wp_product_rate table
define('SR',							'3');//ID of Special Rate entry in wp_product_rate table
define('SINGLE_WIDTH', 					'140');
define('DOUBLE_WIDTH', 					'280');
define('MAX_HEIGHT',                    '280');//Max Height For Double width calculation
define('CLIENT_TYPE',					'1');
define('AGENT_TYPE',					'2');
define('ONLINE_CLIENT',					'3');
/*-----------------Master Table constants-----------------*/
define('USERS_TBL', 					'users');
define('MENU_TBL', 						'menu');
define('USER_PERM_TBL', 				'user_permissions');
define('COUNTRY_TBL', 					'country');
define('STATE_TBL', 					'state');
define('CURRENCY_TBL', 					'currency');
define('NOTIFICATION_TBL', 				'notification');
define('COMPANY_TBL', 					'company');
define('CONSIGNOR_TBL', 				'consignor');
define('CONSIGNEE_TBL', 				'consignee');
define('NOTIFY_TBL', 				    'notify');
define('PORT_TBL', 				        'port_of_dis');
define('LEDGERMASTER_TBL', 				'ledger');
define('BANK_TBL', 				        'bank');
define('ACC_PRODUCT' ,                  'acc_product');
define('CUSTOMER_TBL' ,                 'customer');

/*----------------Bill Table constants-------------*/
define('BILL_TBL',  					'bill_details');
define('BRANCH_TBL', 					'branch');
define('DESIGNATION_TBL', 				'designation');
define('EMPLOYEE_TBL', 					'employee');
define('CLIENT_TBL', 					'clients');
define('FACTORY_TBL', 					'factory');
define('AGENT_TBL', 					'agent');
define('AGENT_RATE_TBL', 				'agent_rates');

/*----------------Invoice Table constants-------------*/
define('INVOICE_TBL',  					'invoice');
define('INVOICE_DTL_TBL',  				'invoice_details');
/*-----------------Product Master Table constants-----------------*/
define('GATHERING_TBL',				    'wp_gathering');
define('POLES_TBL',						'wp_poles');
define('TRACKS_TBL',					'wp_tracks');
define('SHEER_TBL',						'wp_sheer');
define('PELMETS_TBL',					'wp_pelmets');
define('FABRCIS_TBL',					'wp_fabrics');
define('ACCESSORIES_TBL',				'wp_accessories');
define('LINING_MATERIAL_TYPE_TBL',		'wp_lining_material_type');
define('LINING_MATERIAL_TBL',			'wp_lining_material');
define('UNIT_TBL',						'wp_units');
define('PRODUCT_RATE_TBL',				'wp_product_rate');
define('RATE_CALC_TBL',					'wp_rate_calculation_methods');
define('RATE_MAP_TBL',					'wp_product_rate_map');
define('ROOM_TYPE_TBL', 				'wp_room_type');
define('PRODUCT_TYPE_TBL', 				'wp_product_type');
define('PRODUCT_SUBTYPE_TBL', 			'wp_product_subtype');
define('RECC_ITEM_TBL',					'wp_recommended_items');
define('NON_RECC_ITEM_TBL',				'wp_non_recommended_items');
define('PRODUCT_MAPPING_TBL',			'wp_product_mapping');
/*-----------------Enquiry Table constants-----------------*/
define('ENQUIRY_TBL',					'wp_enquiry');
define('ENQUIRY_DET_TBL',				'wp_enquiry_details');
define('ENQUIRY_WIDTH_TBL',				'wp_enquiry_width');
/*-----------------Quotation Table constants-----------------*/
define('QUOTATION_TBL',					'wp_quotation');
define('QUOTATION_DET_TBL',				'wp_quotation_details');
define('QUOTATION_QTY_DET_TBL',			'wp_quotation_qty_details');
/*-----------------Work Order Table constants-----------------*/
define('WORK_ORDER',  					'wp_work_order');
/*-----------------Payment Table constants-----------------*/
define('PAYMENT_TBL',  					'wp_payment');
define('PAYMENT_TRACK_TBL',  			'wp_payment_track');
define('PREFIX_TBL',  			        'prefix_master');


