<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class General_masters extends CI_Controller 
{
	public function __construct()
	{
	 	parent::__construct();	
		$this->load->model('General_masters_model');
		$this->load->library('General_masters_lib');
		
		$this->load->model('Invoice_model');
	}
	/*-----------------------------------COMPANY------------------------------------------*/
	//Company Listing and searching 
	public function company()
	{  
		if(!$this->session->userdata('logged_in')) 
			redirect('Login');
		//else
            //redirect('login?goto='."http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]");
		$url		=	'General_masters/company';
		$order_field= 	'view';
		$join_array = 	array(0=>array(0=>USER_PERM_TBL,1=>"up_menu_id=menu_id",2=>''));
		$result 	=	$this->General_masters_model->select_data(MENU_TBL,'*',array("url"=>$url,"up_emp_id"=>$this->session->userdata('user_id')),'1',$join_array,$order_field,"DESC",'','','');
		if(empty($result))
		{
			$data['page_title'] 	=	'Warning';
	        $data['page_name']  	= 	'warning';
	        $data['page_master']	= 	'Dashboard';
	        $data['page_master_url'] = 	'Dashboard';
	        $data['page_function']	=	'';
			$this->load->view('template/default', $data);
		}
		else
		{	
			$condition 				=	array();
			if($this->input->get("cmp_id"))
			{
				$condition 				=	array("cmp_id"	=>	$this->input->get("cmp_id"));
				$data['company_drpdwn'] =	$this->General_masters_model->select_data(COMPANY_TBL,$select='cmp_id,cmp_name',$condition, $by_row=0, array(),'cmp_name',"ASC",'', 0, null);		
			}
			$data['table_rows']		=	$this->General_masters_model->select_data(COMPANY_TBL,$select='cmp_id,cmp_name,cmp_pol,cmp_shrt_code',$condition, $by_row=0, array(),'cmp_id',"DESC",'', 0, null);
			$data['page_title'] 	=	'Company';
		    $data['page_name']  	= 	'company/company-lists';
		    $data['page_master']	= 	'General Masters';
		    $data['page_master_url'] = 	'General_masters/company';
		    $data['page_function']	=	'List';
			$this->load->view('template/default', $data);
		}
	}
	//Add Company Details
	public function add_company()
	{		
		if(!$this->session->userdata('logged_in')) 
			redirect('Login');
		//else
            //redirect('login?goto='."http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]");			
		$url		=	'General_masters/company';
		$order_field= 	'add';
		$join_array = 	array(0=>array(0=>USER_PERM_TBL,1=>"up_menu_id=menu_id",2=>''));
		$result 	=	$this->General_masters_model->select_data(MENU_TBL,'*',array("url"=>$url,"up_emp_id"=>$this->session->userdata('user_id')),'1',$join_array,$order_field,"DESC",'','','');
		if(empty($result))
		{
			$data['page_title'] 	=	'Warning';
	        $data['page_name']  	= 	'warning';
	        $data['page_master']	= 	'Dashboard';
	        $data['page_master_url'] = 	'Dashboard';
	        $data['page_function']	=	'';
			$this->load->view('template/default', $data);
		}
		else
		{
			$date_format_text =array(0=>"dd/mm/yyyy",1=>"mm/dd/yyyy",2=>"yyyy/mm/dd",3=>"dd-mm-yyyy",4=>"mm-dd-yyyy",5=>"yyyy-mm-dd");
			if ($this->input->post('submit'))
			{	
				//$data['country_drpdwn'] =	$this->General_masters_model->select_data(COUNTRY_TBL,$select='country_id,name',array("country_id"=>$_POST['cmp_country']), $by_row=0, array(),'sortname',"ASC",'', 0, null);
				//$data['state_drpdwn']   =	$this->General_masters_model->select_data(STATE_TBL,$select='state_id,state',array("state_id"=>$_POST['cmp_state']), $by_row=0, array(),'state',"ASC",'', 0, null);					
				//$data['currency_drpdwn']=	$this->General_masters_model->select_data(CURRENCY_TBL,$select='currency_id,currency,currency_code',array("currency_id"=>$_POST['cmp_currency']), $by_row=0, array(),'currency',"ASC",'', 0, null);					
				$this->form_validation->set_error_delimiters('<div style="color:red;text-align:center" class="error"><strong>', '</strong></div>');
				$this->form_validation->set_rules($this->get_company_rule(0));
				if ($this->form_validation->run('add_company') == true) 
				{
					$config['upload_path']   = 'uploads/company/';
					$config['allowed_types'] = 'gif|jpg|png';
					$config['max_size']		 = '5000';
					$config['max_width']  	 = '10240';
					$config['max_height']    = '7680';
					$this->load->library('upload', $config);
					$logo_name			 	 = "";
					if ($this->upload->do_upload('cmp_logo'))
					{
						$upload_data	=	$this->upload->data();
						$logo_name   	= 	$upload_data['file_name'];

						$config['overwrite'] 		= TRUE;
						$config['image_library'] 	= 'gd2';
                    	$config['source_image'] 	= $this->upload->upload_path.$this->upload->file_name;
                    	$config['maintain_ratio'] 	= TRUE;
                    	$config['width'] 			= 550;
                    	$config['height'] 			= 550;
                    	$this->load->library('image_lib',$config); 

                    	if ( !$this->image_lib->resize())
                    	{
               				$this->session->set_flashdata('error', $this->image_lib->display_errors('', ''));   
             			}
					}
					$insert_array	=	array(	"cmp_name"				=>	$this->input->post("cmp_name"),
												"cmp_pol"				=>	$this->input->post("cmp_pol"),
												"cmp_shrt_code"			=>	$this->input->post("cmp_shrt_code"),
												"cmp_created_time"		=>	date('Y-m-d H:i:s')
											);
						$this->General_masters_model->save_data(COMPANY_TBL,$insert_array,array(),0);
						$this->session->set_flashdata('msg', "Company Added Successfully..!");
						redirect('General_masters/company');
					
				}
				else
				{
					$this->form_validation->set_message('rule', 'Error Message');
				}
			}
			$data['recent_list'] 	=	$this->General_masters_model->select_data(COMPANY_TBL,$select='cmp_id,cmp_name,cmp_pol,cmp_shrt_code',array(), $by_row=0, array(),'cmp_id',"DESC",'', 10,0);
			$data['date_format_text']=	$date_format_text;
			$data['page_title'] 	=	'Company';
		    $data['page_name']  	= 	'company/add-company';
		    $data['page_master']	= 	'General Masters';
		    $data['page_master_url'] = 	'General_masters/company';
		    $data['page_function']	=	'Add';
			$this->load->view('template/default', $data);
		}
	}
	//Edit Company Details
	public function edit_company()
	{	
		if(!$this->session->userdata('logged_in')) 
			redirect('Login');
		//else
            //redirect('login?goto='."http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]");
		$url		=	'General_masters/company';
		$order_field= 	'edit';
		$join_array = 	array(0=>array(0=>USER_PERM_TBL,1=>"up_menu_id=menu_id",2=>''));
		$result 	=	$this->General_masters_model->select_data(MENU_TBL,'*',array("url"=>$url,"up_emp_id"=>$this->session->userdata('user_id')),'1',$join_array,$order_field,"DESC",'','','');
		if(empty($result))
		{
			$data['page_title'] 	=	'Warning';
	        $data['page_name']  	= 	'warning';
	        $data['page_master']	= 	'Dashboard';
	        $data['page_master_url'] = 	'Dashboard';
	        $data['page_function']	=	'';
			$this->load->view('template/default', $data);
		}
		else
		{	
			$date_format_text =array(0=>"dd/mm/yyyy",1=>"mm/dd/yyyy",2=>"yyyy/mm/dd",3=>"dd-mm-yyyy",4=>"mm-dd-yyyy",5=>"yyyy-mm-dd");			
		
			$cmp_id 				=	$this->uri->segment(3);
			$data['cmp_id']			=	$cmp_id;
			$data['edit_company']   = 	$this->General_masters_model->select_data(COMPANY_TBL,'*',array("cmp_id"=>$cmp_id),	1, array(),'cmp_name',"ASC",'', '','');
			//$cmp_country 			=	$data['edit_company']->cmp_country;
			//$cmp_state 				=	$data['edit_company']->cmp_state;
			//$cmp_currency 			=	$data['edit_company']->cmp_currency;
			$data['recent_list'] 	=	$this->General_masters_model->select_data(COMPANY_TBL,$select='cmp_id,cmp_name,cmp_pol,cmp_shrt_code',array(), 0, array(),'cmp_id',"DESC",'', 10,0);
			//$data['country_drpdwn'] =	$this->General_masters_model->select_data(COUNTRY_TBL,$select='country_id,name',array("country_id"=>$cmp_country), 0, array(),'sortname',"ASC",'', 0, null);
			//$data['state_drpdwn']   =	$this->General_masters_model->select_data(STATE_TBL,$select='state_id,state',array("state_id"=>$cmp_state),0, array(),'state',"ASC",'', 0, null);
			//$data['currency_drpdwn']=	$this->General_masters_model->select_data(CURRENCY_TBL,$select='currency_id,currency,currency_code',array("currency_id"=>$cmp_currency), $by_row=0, array(),'currency',"ASC",'', 0, null);		
			$data['date_format_text']=	$date_format_text;
			$data['page_title'] 	=	'Company';
		    $data['page_name']  	= 	'company/edit-company';
		    $data['page_master']	= 	'General Masters';
		    $data['page_master_url'] = 	'General_masters/company';
		    $data['page_function']	=	'Edit';
			if ($this->input->post('submit'))
			{	
				//$data['country_drpdwn'] =	$this->General_masters_model->select_data(COUNTRY_TBL,$select='country_id,name',array("country_id"=>$_POST['cmp_country']), $by_row=0, array(),'sortname',"ASC",'', 0, null);
				//$data['state_drpdwn']   =	$this->General_masters_model->select_data(STATE_TBL,$select='state_id,state',array("state_id"=>$_POST['cmp_state']), $by_row=0, array(),'state',"ASC",'', 0, null);					
				//$data['currency_drpdwn']=	$this->General_masters_model->select_data(CURRENCY_TBL,$select='currency_id,currency,currency_code',array("currency_id"=>$_POST['cmp_currency']), $by_row=0, array(),'currency',"ASC",'', 0, null);					
				$this->form_validation->set_error_delimiters('<div style="color:red;text-align:center" class="error"><strong>', '</strong></div>');
				$this->form_validation->set_rules($this->get_company_rule(1));
				if ($this->form_validation->run('edit_company') == true) 
				{
					$config['upload_path']   = 'uploads/company/';
					$config['allowed_types'] = 'gif|jpg|png';
					$config['max_size']		 = '5000';
					$config['max_width']  	 = '10240';
					$config['max_height']    = '7680';
					$this->load->library('upload', $config);
					$logo_name			 	 = "";
					if ($this->upload->do_upload('cmp_logo'))
					{
						$upload_data	 =	$this->upload->data();
						$logo_name   	 = 	$upload_data['file_name'];
						$insert_array['cmp_logo']=	$logo_name;

						$config['overwrite'] 		= TRUE;
						$config['image_library'] 	= 'gd2';
                    	$config['source_image'] 	= $this->upload->upload_path.$this->upload->file_name;
                    	$config['maintain_ratio'] 	= TRUE;
                    	$config['width'] 			= 550;
                    	$config['height'] 			= 550;
                    	$this->load->library('image_lib',$config); 

                    	if ( !$this->image_lib->resize())
                    	{
               				$this->session->set_flashdata('error', $this->image_lib->display_errors('', ''));   
             			}
					}
					$insert_array["cmp_name"] 				=		$this->input->post("cmp_name");
					$insert_array["cmp_pol"]				=		$this->input->post("cmp_pol");
					$insert_array["cmp_shrt_code"]				=		$this->input->post("cmp_shrt_code");
					
					
					$cmp_id 		=	$this->input->post("cmp_id");
					$this->General_masters_model->save_data(COMPANY_TBL,$insert_array,array("cmp_id"=>$cmp_id),$cmp_id);
					$this->session->set_flashdata('msg', "Company Updated Successfully..!");
					redirect('General_masters/company');					
				}
				else
				{
					$this->form_validation->set_message('rule', 'Error Message');
				}
			}
		}
		$this->load->view('template/default', $data);
	}
	
	 
	//Serverside validation rule - Company
	public function get_company_rule($update=0)
	{
		$config 	= array();
        $config []	=   array(
		                     'field'   => 'cmp_name', 
		                     'label'   => 'Company Name', 
		                     'rules'   => 'required'
		                  );
        $config []	=   array(
		                     'field'   => 'cmp_pol', 
		                     'label'   => 'Place Of Loading', 
		                     'rules'   => 'required'
		                  );
        $config []	=   array(
		                     'field'   => 'cmp_shrt_code', 
		                     'label'   => 'Short Code', 
		                     'rules'   => 'required'
		                  );
       
        return $config;
    }
	
	
	
    public function get_port_of_dis_rule($update=0)
	{
		$config 	= array();
        $config []	=   array(
		                     'field'   => 'port_of_dis_name', 
		                     'label'   => 'Port Name', 
		                     'rules'   => 'required'
		                  );
        $config []	=   array(
		                     'field'   => 'port_of_dis_shrt_code', 
		                     'label'   => 'Short Code', 
		                     'rules'   => 'required'
		                  );
       
        return $config;
    }




		//Serverside validation rule - ledger Group
	public function get_ledgergroup_rule($update=0)
	{
		$config 	= array();
        $config []	=   array(
		                     'field'   => 'consignor_name', 
		                     'label'   => 'Consignor Name', 
		                     'rules'   => 'required'
		                  );
        $config []	=   array(
		                     'field'   => 'consignor_addr1', 
		                     'label'   => 'Address Line 1', 
		                     'rules'   => 'required'
		                  );
        // $config []	=   array(
		      //                'field'   => 'consignor_addr2', 
		      //                'label'   => 'Address Line 2', 
		      //                'rules'   => 'required'
		      //             );
        // $config []	=   array(
		      //                'field'   => 'consignor_addr3', 
		      //                'label'   => 'Address Line 3', 
		      //                'rules'   => 'required'
		      //             );
        // $config []	=   array(
		      //                'field'   => 'consignor_addr4', 
		      //                'label'   => 'Address Line 4', 
		      //                'rules'   => 'required'
		      //             );
        
        // $config []	=   array(
		      //                'field'   => 'consignor_con_person', 
		      //                'label'   => 'Contact Person', 
		      //                'rules'   => 'required'
		      //             );
        // $config []	=   array(
		      //                'field'   => 'consignor_con_no', 
		      //                'label'   => 'Contact Number', 
		      //                'rules'   => 'required|numeric'
		      //             );
        // $config []	=   array(
		      //                'field'   => 'consignor_alt_no', 
		      //                'label'   => 'Alternate Number', 
		      //                'rules'   => 'required|numeric'
		      //             );

      
        // $config []	=   array(
		      //                'field'   => 'consignor_fax', 
		      //                'label'   => 'Fax', 
		      //                'rules'   => 'required'
		      //             );
    
       
   
		 
       
        return $config;
    }
	//serverside validation rule - ledger
	

    public function get_consignee_rule($update=0)
	{
		$config 	= array();
        $config []	=   array(
		                     'field'   => 'consignee_name', 
		                     'label'   => 'Consignee Name', 
		                     'rules'   => 'required'
		                  );
        $config []	=   array(
		                     'field'   => 'consignee_addr1', 
		                     'label'   => 'Address Line 1', 
		                     'rules'   => 'required'
		                  );
        // $config []	=   array(
		      //                'field'   => 'consignee_addr2', 
		      //                'label'   => 'Address Line 2', 
		      //                'rules'   => 'required'
		      //             );
        // $config []	=   array(
		      //                'field'   => 'consignee_addr3', 
		      //                'label'   => 'Address Line 3', 
		      //                'rules'   => 'required'
		      //             );
        // $config []	=   array(
		      //                'field'   => 'consignee_addr4', 
		      //                'label'   => 'Address Line 4', 
		      //                'rules'   => 'required'
		      //             );
        // $config []	=   array(
		      //               'field'   => 'consignee_country_id', 
		      //                'label'   => 'Country', 
		      //                'rules'   => 'required|numeric'
		      //             );
        // $config []	=   array(
		      //                'field'   => 'consignee_state_id', 
		      //                'label'   => 'State', 
		      //                'rules'   => 'required|numeric'
		      //             );
        // $config []	=   array(
		      //               'field'   => 'consignee_pin', 
		      //                'label'   => 'Pincode', 
		      //                'rules'   => 'required|numeric'
		      //             );
        // $config []	=   array(
		      //                'field'   => 'consignee_con_person', 
		      //                'label'   => 'Contact Person', 
		      //                'rules'   => 'required'
		      //             );
        // $config []	=   array(
		      //                'field'   => 'consignee_con_no', 
		      //                'label'   => 'Contact Number', 
		      //                'rules'   => 'required|numeric'
		      //             );
        // $config []	=   array(
		      //                'field'   => 'consignee_alt_no', 
		      //                'label'   => 'Alternate Number', 
		      //                'rules'   => 'required|numeric'
		      //             );

      
        // $config []	=   array(
		      //                'field'   => 'consignee_fax', 
		      //                'label'   => 'Fax', 
		      //                'rules'   => 'required'
		      //             );
    
       
   
		 
       
        return $config;
    }


 //    public function get_notify_rule($update=0)
	// {
	// 	$config 	= array();
 //        $config []	=   array(
	// 	                     'field'   => 'notify_name', 
	// 	                     'label'   => 'Notify Name', 
	// 	                     'rules'   => 'required'
	// 	                  );
 //        $config []	=   array(
	// 	                     'field'   => 'notify_addr1', 
	// 	                     'label'   => 'Address Line 1', 
	// 	                     'rules'   => 'required'
	// 	                  );
 //        $config []	=   array(
	// 	                     'field'   => 'notify_addr2', 
	// 	                     'label'   => 'Address Line 2', 
	// 	                     'rules'   => 'required'
	// 	                  );
 //        $config []	=   array(
	// 	                    'field'   => 'notify_country_id', 
	// 	                     'label'   => 'Country', 
	// 	                     'rules'   => 'required|numeric'
	// 	                  );
 //        $config []	=   array(
	// 	                     'field'   => 'notify_state_id', 
	// 	                     'label'   => 'State', 
	// 	                     'rules'   => 'required|numeric'
	// 	                  );
 //        $config []	=   array(
	// 	                    'field'   => 'notify_pin', 
	// 	                     'label'   => 'Pincode', 
	// 	                     'rules'   => 'required|numeric'
	// 	                  );
 //        $config []	=   array(
	// 	                     'field'   => 'notify_con_person', 
	// 	                     'label'   => 'Contact Person', 
	// 	                     'rules'   => 'required'
	// 	                  );
 //        $config []	=   array(
	// 	                     'field'   => 'notify_con_no', 
	// 	                     'label'   => 'Contact Number', 
	// 	                     'rules'   => 'required|numeric'
	// 	                  );
 //        $config []	=   array(
	// 	                     'field'   => 'notify_alt_no', 
	// 	                     'label'   => 'Alternate Number', 
	// 	                     'rules'   => 'required|numeric'
	// 	                  );

      
 //        $config []	=   array(
	// 	                     'field'   => 'notify_fax', 
	// 	                     'label'   => 'Fax', 
	// 	                     'rules'   => 'required'
	// 	                  );
    
       
   
		 
       
 //        return $config;
 //    }



	public function get_customer_rule($update=0)
	{
		$config 	= array();
        $config []	=   array(
		                     'field'   => 'customer_name', 
		                     'label'   => 'Customer Name', 
		                     'rules'   => 'required'
		                  );
        $config []	=   array(
		                     'field'   => 'customer_addr1', 
		                     'label'   => 'Address Line 1', 
		                     'rules'   => 'required'
		                  );
       
        return $config;
    }








	public function get_ledger_rule($update=0)
	{
		$config 	= array();
        $config []	=   array(
		                     'field'   => 'ledger_name', 
		                     'label'   => 'Ledger Name', 
		                     'rules'   => 'required'
		                  );
						  
		 $config []	=   array(
		                     'field'   => 'parent_ledger_group_id', 
		                     'label'   => 'Parent Ledger Group Name', 
		                     'rules'   => 'required'
		                  );
		
		$config []	=   array(
		                     'field'   => 'ledger_type', 
		                     'label'   => 'Ledger Type ', 
		                     'rules'   => 'required'
		                  );
		 $config []	=   array(
		                     'field'   => 'opening_balance', 
		                     'label'   => 'Opening Balance ', 
		                     'rules'   => 'required'
		                  );
		 $config []	=   array(
		                     'field'   => 'account_type', 
		                     'label'   => 'Account Type ', 
		                     'rules'   => 'required'
		                  );
		 $config []	=   array(
		                     'field'   => 'ledger_company_id', 
		                     'label'   => 'Company ', 
		                     'rules'   => 'required'
		                  );
		 $config []	=   array(
		                     'field'   => 'ledger_branch_id', 
		                     'label'   => 'Branch ', 
		                     'rules'   => 'required'
		                  );
    
    
    
       
   
		 
       
        return $config;
    }
	
	
    function _check_cmp_email($email,$update)
    { 
    	$condition 	=	array();
    	if($update==1)
    	{
    		$condition['cmp_id !=']	=	$this->input->post("cmp_id");
    	}
    	$condition['cmp_email']	=	$email;
        $return_value = $this->General_masters_model->select_data(COMPANY_TBL,'count(*) cnt',$condition,	1, array(),'cmp_name',"ASC",'', '','');
        if ($return_value->cnt !=0)
        {
            $this->form_validation->set_message('_check_cmp_email', '<div style="color:red;text-align:center" class="error"><strong> Sorry, This email is already used by another user please select another one</strong></div>');
            return FALSE;
        }
        else
        {
        	return TRUE;
        }
    }
	/*-----------------------------------BRANCH------------------------------------------*/
	//Branch Listing and searching 
	public function branch()
	{  		
		if(!$this->session->userdata('logged_in')) 
			redirect('Login');
		//else
            //redirect('login?goto='."http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]");
		$url		=	'General_masters/branch';
		$order_field= 	'view';
		$join_array = 	array(0=>array(0=>USER_PERM_TBL,1=>"up_menu_id=menu_id",2=>''));
		$result 	=	$this->General_masters_model->select_data(MENU_TBL,'*',array("url"=>$url,"up_emp_id"=>$this->session->userdata('user_id')),'1',$join_array,$order_field,"DESC",'','','');
		if(empty($result))
		{
			$data['page_title'] 	=	'Warning';
	        $data['page_name']  	= 	'warning';
	        $data['page_master']	= 	'Dashboard';
	        $data['page_master_url'] = 	'Dashboard';
	        $data['page_function']	=	'';
			$this->load->view('template/default', $data);
		}
		else
		{
			$condition 				=	array();
			if($_REQUEST)
			{
				if($this->input->get("branch_id")!='')
					$condition["branch_id"] 	=	$this->input->get("branch_id");
				
			}
			$data['table_rows']		=	$this->General_masters_model->select_data(BRANCH_TBL,$select='branch_id,branch_name,branch_pol,branch_shrt_code',$condition, $by_row=0, array(),'branch_id',"DESC",'', 0, null);
			//$data['company_drpdwn'] =	$this->General_masters_model->select_data(COMPANY_TBL,$select='cmp_id,cmp_name',array(), $by_row=0, array(),'cmp_name',"ASC",'', 0, null);
			$data['branch_drpdwn']  =	$this->General_masters_model->select_data(BRANCH_TBL,$select='branch_id,branch_name',array(), $by_row=0, array(),'branch_name',"ASC",'', 0, null);
			$data['page_title'] 	=	'Branch';
		    $data['page_name']  	= 	'branch/branch-lists';
		    $data['page_master']	= 	'General Masters';
		    $data['page_master_url']= 	'General_masters/branch';
		    $data['page_function']	=	'List';
			$this->load->view('template/default', $data);
		}
	}
	//Add Branch Details
	public function add_branch()
	{			
		if(!$this->session->userdata('logged_in')) 
			redirect('Login');
		//else
            //redirect('login?goto='."http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]");
		$url		=	'General_masters/branch';
		$order_field= 	'add';
		$join_array = 	array(0=>array(0=>USER_PERM_TBL,1=>"up_menu_id=menu_id",2=>''));
		$result 	=	$this->General_masters_model->select_data(MENU_TBL,'*',array("url"=>$url,"up_emp_id"=>$this->session->userdata('user_id')),'1',$join_array,$order_field,"DESC",'','','');
		if(empty($result))
		{
			$data['page_title'] 	=	'Warning';
	        $data['page_name']  	= 	'warning';
	        $data['page_master']	= 	'Dashboard';
	        $data['page_master_url'] = 	'Dashboard';
	        $data['page_function']	=	'';
			$this->load->view('template/default', $data);
		}
		else
		{
			if ($this->input->post('submit'))
			{			
				$this->form_validation->set_error_delimiters('<div style="color:red;text-align:center" class="error"><strong>', '</strong></div>');
				$this->form_validation->set_rules($this->get_branch_rule(0));
				if ($this->form_validation->run('add_branch') == true) 
				{
					$insert_array	=	array(	"branch_name"			=>	$this->input->post("branch_name"),
												"branch_pol"			=>	$this->input->post("branch_pol"),
												"branch_shrt_code"		=>	$this->input->post("branch_shrt_code"),
												"branch_bill_no"        =>  $this->input->post("branch_bill_no"),
												"branch_created_time"	=>	date('Y-m-d H:i:s')
											);
					$this->General_masters_model->save_data(BRANCH_TBL,$insert_array,array(),0);
					$this->session->set_flashdata('msg', "Branch Added Successfully..!");
					redirect('General_masters/branch');
				} 
				else
				{
					$this->form_validation->set_message('rule', 'Error Message');
				}
			}
			$data['recent_list'] 	=	$this->General_masters_model->select_data(BRANCH_TBL,$select='branch_id,branch_name,branch_pol,branch_shrt_code',array(), $by_row=0, array(),'branch_id',"DESC",'', 10,0);
			$data['company_drpdwn'] =	$this->General_masters_model->select_data(COMPANY_TBL,$select='cmp_id,cmp_name',array(), $by_row=0, array(),'cmp_name',"ASC",'', 0, null);
			$data['page_title'] 	=	'Branch';
		    $data['page_name']  	= 	'branch/add-branch';
		    $data['page_master']	= 	'General Masters';
		    $data['page_master_url'] = 	'General_masters/branch';
		    $data['page_function']	=	'Add';
			$this->load->view('template/default', $data);
		}
	}
	//Edit Branch Details
	public function edit_branch()
	{	
		if(!$this->session->userdata('logged_in')) 
			redirect('Login');
		//else
            //redirect('login?goto='."http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]");
		$url		=	'General_masters/branch';
		$order_field= 	'edit';
		$join_array = 	array(0=>array(0=>USER_PERM_TBL,1=>"up_menu_id=menu_id",2=>''));
		$result 	=	$this->General_masters_model->select_data(MENU_TBL,'*',array("url"=>$url,"up_emp_id"=>$this->session->userdata('user_id')),'1',$join_array,$order_field,"DESC",'','','');
		if(empty($result))
		{
			$data['page_title'] 	=	'Warning';
	        $data['page_name']  	= 	'warning';
	        $data['page_master']	= 	'Dashboard';
	        $data['page_master_url'] = 	'Dashboard';
	        $data['page_function']	=	'';
			$this->load->view('template/default', $data);
		}
		else
		{	
			$branch_id 				=	$this->uri->segment(3);
			$data['branch_id']		=	$branch_id;
			$data['edit_branch']    = 	$this->General_masters_model->select_data(BRANCH_TBL,'*',array("branch_id"=>$branch_id),1, array(),'branch_name',"ASC",'', '','');
			//$branch_cmp_id 			=	$data['edit_branch']->branch_cmp_id;
			$data['recent_list'] 	=	$this->General_masters_model->select_data(BRANCH_TBL,$select='branch_id,branch_name,branch_pol,branch_shrt_code',array(), $by_row=0, array(),'branch_id',"DESC",'', 10,0);
			//$data['company_drpdwn'] =	$this->General_masters_model->select_data(COMPANY_TBL,$select='cmp_id,cmp_name',array("cmp_id" => $branch_cmp_id), $by_row=0, array(),'cmp_name',"ASC",'', 0, null);
			$data['page_title'] 	=	'Branch';
		    $data['page_name']  	= 	'branch/edit-branch';
		    $data['page_master']	= 	'General Masters';
		    $data['page_master_url'] = 	'General_masters/branch';
		    $data['page_function']	=	'Edit';
			if ($this->input->post('submit'))
			{			
				$this->form_validation->set_error_delimiters('<div style="color:red;text-align:center" class="error"><strong>', '</strong></div>');
				$this->form_validation->set_rules($this->get_branch_rule(1));
				if ($this->form_validation->run('edit_branch') == true) 
				{
					$insert_array	=	array(	"branch_name"			=>	$this->input->post("branch_name"),
												"branch_pol"			=>	$this->input->post("branch_pol"),
												"branch_shrt_code"		=>	$this->input->post("branch_shrt_code"),
												"branch_bill_no"        =>  $this->input->post("branch_bill_no")
											);
					$branch_id 		=	$this->input->post("branch_id");
					$this->General_masters_model->save_data(BRANCH_TBL,$insert_array,array("branch_id"=>$branch_id),$branch_id);
					$this->session->set_flashdata('msg', "Branch Updated Successfully..!");
					redirect('General_masters/branch');
				}
				else
				{
					$this->form_validation->set_message('rule', 'Error Message');
				}
			}
		}
		$this->load->view('template/default', $data);
	}
	//Select company
	public function get_company()
	{
		$entered_str 	=	$this->input->get("q");
		echo $this->General_masters_model->get_company($entered_str);
	}
	//Select branch
	public function get_branch()
	{
		$entered_str 	=	$this->input->get("q");
		$company_id 	=	$this->input->get("company_id");
		echo $this->General_masters_model->get_branch($entered_str,$company_id);
	}
	public function get_port_of_dis()
	{
		$entered_str 	=	$this->input->get("q");
		echo $this->General_masters_model->get_port_of_dis($entered_str);
	}
	//Serverside validation rule - Branch
	public function get_branch_rule($update=0)
	{
		$config 	= array();
        $config []	=   array(
		                     'field'   => 'branch_name', 
		                     'label'   => 'Branch Name', 
		                     'rules'   => 'required'
		                  );
        $config []	=   array(
		                     'field'   => 'branch_pol', 
		                     'label'   => 'Place Of Loading', 
		                     'rules'   => 'required'
		                  );
        $config []	=   array(
		                     'field'   => 'branch_shrt_code', 
		                     'label'   => 'Short Code', 
		                     'rules'   => 'required'
		                  );
        $config []	=   array(
		                     'field'   => 'branch_bill_no', 
		                     'label'   => 'Bill Incrment Number', 
		                     'rules'   => 'required'
		                  );
        return $config;
    }


	///////ledger Group 
	
	
	public function get_ledgergrouplist()
	{
		 
		echo $this->General_masters_model->get_ledgergrouplist();
	}
	
	public function get_ledgerlist()
	{
		 
		echo $this->General_masters_model->get_ledgerlist();
	}
	
	
	public function get_ledgergroup()
	{
		 
		echo $this->General_masters_model->get_ledgergroup();
	}
	
 
	
	// public function get_ledgergroupsearch()
	// {
	// 	$entered_str 	=	$this->input->get("q");		
	// 	$id 	=	$this->input->get("id");
	// 	echo $this->General_masters_model->get_ledgergroupsearch($entered_str,$id);
	// }

	public function get_consignorsearch()
	{
		$entered_str 	=	$this->input->get("q");		
		$id 	=	$this->input->get("id");
		echo $this->General_masters_model->get_consignorsearch($entered_str,$id);
	}

	public function get_consigneesearch()
	{
		$entered_str 	=	$this->input->get("q");		
		$id 	=	$this->input->get("id");
		echo $this->General_masters_model->get_consigneesearch($entered_str,$id);
	}

	public function get_customersearch()
	{
		$entered_str 	=	$this->input->get("q");		
		$id 	=	$this->input->get("id");
		echo $this->General_masters_model->get_customersearch($entered_str,$id);
	}
	
	public function get_notifysearch()
	{
		$entered_str 	=	$this->input->get("q");		
		$id 	=	$this->input->get("id");
		echo $this->General_masters_model->get_notifysearch($entered_str,$id);
	}
	
	public function get_ledgersearch()
	{
		$entered_str 	  =	$this->input->get("q");		
		      $id 	      =	$this->input->get("id");
			  $ledger_group_id  = $this->input->get("ledger_group_id");
		 echo $this->General_masters_model->get_ledgersearch($entered_str,$id,$ledger_group_id);
	}
	////ldeger
	
	public function get_ledger()
	{
		 
		echo $this->General_masters_model->get_ledger();
	}
	
	


	

///////Consignor Listing and searching 
public function consignor()	

	{  
		if(!$this->session->userdata('logged_in')) 
			redirect('Login');
		//else
            //redirect('login?goto='."http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]");
		$url		=	'General_masters/consignor';
		$order_field= 	'view';
		$join_array = 	array(0=>array(0=>USER_PERM_TBL,1=>"up_menu_id=menu_id",2=>''));
		$result 	=	$this->General_masters_model->select_data(MENU_TBL,'*',array("url"=>$url,"up_emp_id"=>$this->session->userdata('user_id')),'1',$join_array,$order_field,"DESC",'','',''); 
		if(empty($result))
		{ 
		
			$this->load->view('template/default');
		}
		else
		{	
			$condition 				=	array();
			//print_r($this->input->get("consignor_id"));
 			if($this->input->get("consignor_id"))
			{
			
				$condition 				=	array("consignor_id"	=>	$this->input->get("consignor_id"));
				$data['consignor_drpdwn'] =	$this->General_masters_model->select_data(CONSIGNOR_TBL,$select='consignor_id,consignor_name',$condition, $by_row=0, array(),'consignor_name',"ASC",'', 0, null);
						
				 
			}
			$data['table_rows']		=	$this->General_masters_model->get_consignorlist($this->input->get("consignor_id"));
			$data['page_title'] 	=	'Shipper/Exporter';
		    $data['page_name']  	= 	'consignor/consignor-list';
		    $data['page_master']	= 	'General Masters';
		    $data['page_master_url'] = 	'General_masters/consignor';
		    $data['page_function']	=	'List';
			$this->load->view('template/default', $data);
		}
	}


	//Add Consignor Details
	public function add_consignor()
	{		
		if(!$this->session->userdata('logged_in')) 
			redirect('Login');
		//else
            //redirect('login?goto='."http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]");			
		$url		=	'General_masters/consignor';
		$order_field= 	'add';
		$join_array = 	array(0=>array(0=>USER_PERM_TBL,1=>"up_menu_id=menu_id",2=>''));
		$result 	=	$this->General_masters_model->select_data(MENU_TBL,'*',array("url"=>$url,"up_emp_id"=>$this->session->userdata('user_id')),'1',$join_array,$order_field,"DESC",'','','');
		if(empty($result))
		{
			 
			$this->load->view('template/default');
		}
		else
		{
			$date_format_text =array(0=>"dd/mm/yyyy",1=>"mm/dd/yyyy",2=>"yyyy/mm/dd",3=>"dd-mm-yyyy",4=>"mm-dd-yyyy",5=>"yyyy-mm-dd");
			if ($this->input->post('submit'))
			{	
				
								
				//$data['country_drpdwn'] =	$this->General_masters_model->select_data(COUNTRY_TBL,$select='country_id,name',array("country_id"=>$_POST['consignor_country_id']), $by_row=0, array(),'sortname',"ASC",'', 0, null);
				//$data['state_drpdwn']   =	$this->General_masters_model->select_data(STATE_TBL,$select='state_id,state',array("state_id"=>$_POST['consignor_state_id']), $by_row=0, array(),'state',"ASC",'', 0, null);		
				$this->form_validation->set_error_delimiters('<div style="color:red;text-align:center" class="error"><strong>', '</strong></div>');
				$this->form_validation->set_rules($this->get_ledgergroup_rule(0));
				if ($this->form_validation->run('add_consignor') == true) 
				{
					
					
					
					$insert_array	=	array(	"consignor_name"				=>	$this->input->post("consignor_name"),
												"consignor_addr1"				=>	$this->input->post("consignor_addr1"),
 												"consignor_addr2"				=>	$this->input->post("consignor_addr2"),
												"consignor_addr3"				=>	$this->input->post("consignor_addr3"),
 												"consignor_addr4"				=>	$this->input->post("consignor_addr4"),
												// "consignor_country_id"			=>	$this->input->post("consignor_country_id"),
												// "consignor_state_id"			=>	$this->input->post("consignor_state_id"),
												// "consignor_pin"				    =>	$this->input->post("consignor_pin"),
												"consignor_con_person"			=>	$this->input->post("consignor_con_person"),
												// "consignor_con_no"				=>	$this->input->post("consignor_con_no"),
												// "consignor_alt_no"				=>	$this->input->post("consignor_alt_no"),
												// "consignor_fax"				    =>	$this->input->post("consignor_fax"),
												"consignor_created_date"		=>	date('Y-m-d H:i:s'),
											);
					
						$this->General_masters_model->save_data(CONSIGNOR_TBL,$insert_array,array(),0);
						$this->session->set_flashdata('msg', "Consignor Added Successfully..!");
						redirect('General_masters/consignor');
						
					
				}
				else
				{
					$this->form_validation->set_message('rule', 'Error Message');
				}
			} 
			//$data['ledger_drpdwn'] =	$this->General_masters_model->select_data(LEDGER_TBL,$select='consignor_id,ledger_group_name',array(), $by_row=0, array(),'ledger_group_name',"ASC",'', 0, null);
						
				
			$data['recent_list'] 	=	$this->General_masters_model->get_consignor();
			$data['date_format_text']=	$date_format_text;
			$data['page_title'] 	=	'Shipper/Exporter';
		    $data['page_name']  	= 	'consignor/add-consignor';
		    $data['page_master']	= 	'General Masters';
		    $data['page_master_url'] = 	'General_masters/consignor';
		    $data['page_function']	=	'Add';
		 	$this->load->view('template/default', $data);
		}
	}




	//Edit Consignor Details
	public function edit_consignor()
	{	
		if(!$this->session->userdata('logged_in')) 
			redirect('Login');
		//else
            //redirect('login?goto='."http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]");
		$url		=	'General_masters/consignor';
		$order_field= 	'edit';
		$join_array = 	array(0=>array(0=>USER_PERM_TBL,1=>"up_menu_id=menu_id",2=>''));
		$result 	=	$this->General_masters_model->select_data(MENU_TBL,'*',array("url"=>$url,"up_emp_id"=>$this->session->userdata('user_id')),'1',$join_array,$order_field,"DESC",'','','');
		if(empty($result))
		{
			
			$this->load->view('template/default');
		}
		else
		{	
			 			
		
		
		$consignor_id 				=	$this->uri->segment(3);
			$data['consignor_id']			=	$consignor_id;
			
			
			$data['edit_consignor']    = 	$this->General_masters_model->select_data(CONSIGNOR_TBL,'*',array("consignor_id"=>$consignor_id),1, array(),'consignor_name',"ASC",'', '','');

			
			$data['recent_list'] 	=	$this->General_masters_model->get_consignor();
								
				
		
		
			 
		
			//$consignor_country_id 			=	$data['edit_consignor']->consignor_country_id;
			//$consignor_state_id 				=	$data['edit_consignor']->consignor_state_id;
			//$data['country_drpdwn'] =	$this->General_masters_model->select_data(COUNTRY_TBL,$select='country_id,name',array("country_id"=>$consignor_country_id), 0, array(),'sortname',"ASC",'', 0, null);
			//$data['state_drpdwn']   =	$this->General_masters_model->select_data(STATE_TBL,$select='state_id,state',array("state_id"=>$consignor_state_id),0, array(),'state',"ASC",'', 0, null); 
 			$data['page_title'] 	=	'Shipper/Exporter';
		    $data['page_name']  	= 	'consignor/edit-consignor';
		    $data['page_master']	= 	'General Masters';
		    $data['page_master_url'] = 	'General_masters/consignor';
		    $data['page_function']	=	'Edit';
			if ($this->input->post('submit'))
			{	
				 
			 				
				//$data['country_drpdwn'] =	$this->General_masters_model->select_data(COUNTRY_TBL,$select='country_id,name',array("country_id"=>$_POST['consignor_country_id']), $by_row=0, array(),'sortname',"ASC",'', 0, null);
				//$data['state_drpdwn']   =	$this->General_masters_model->select_data(STATE_TBL,$select='state_id,state',array("state_id"=>$_POST['consignor_state_id']), $by_row=0, array(),'state',"ASC",'', 0, null);		
				$this->form_validation->set_error_delimiters('<div style="color:red;text-align:center" class="error"><strong>', '</strong></div>');
			$this->form_validation->set_rules($this->get_ledgergroup_rule(1));
			 if ($this->form_validation->run('edit_consignor') == true) 
				{
				 
					$insert_array["consignor_name"] 				= $this->input->post("consignor_name");
					$insert_array["consignor_addr1"] 				= $this->input->post("consignor_addr1");
					$insert_array["consignor_addr2"] 				= $this->input->post("consignor_addr2");
					$insert_array["consignor_addr3"] 				= $this->input->post("consignor_addr3");
					$insert_array["consignor_addr4"] 				= $this->input->post("consignor_addr4");
					// $insert_array["consignor_country_id"] 			= $this->input->post("consignor_country_id");
					// $insert_array["consignor_state_id"] 			= $this->input->post("consignor_state_id");
					// $insert_array["consignor_pin"] 			     	= $this->input->post("consignor_pin");
					$insert_array["consignor_con_person"] 			= $this->input->post("consignor_con_person");
					// $insert_array["consignor_con_no"] 				= $this->input->post("consignor_con_no");
					// $insert_array["consignor_alt_no"] 				= $this->input->post("consignor_alt_no");
					// $insert_array["consignor_fax"] 				    = $this->input->post("consignor_fax");
					$insert_array["consignor_created_date"] 		= date('Y-m-d H:i:s');
					
    					
					$consignor_id 		=	$this->input->post("consignor_id");
					$this->General_masters_model->save_data(CONSIGNOR_TBL,$insert_array,array("consignor_id"=>$consignor_id),$consignor_id);
					$this->session->set_flashdata('msg', "Consignor Updated Successfully..!");
					redirect('General_masters/consignor');					
				}
			 else
				{
					$this->form_validation->set_message('rule', 'Error Message');
			 }
			}
		}
		$this->load->view('template/default', $data);
	}


public function consignee()	

	{  
		if(!$this->session->userdata('logged_in')) 
			redirect('Login');
		//else
            //redirect('login?goto='."http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]");
		$url		=	'General_masters/consignee';
		$order_field= 	'view';
		$join_array = 	array(0=>array(0=>USER_PERM_TBL,1=>"up_menu_id=menu_id",2=>''));
		$result 	=	$this->General_masters_model->select_data(MENU_TBL,'*',array("url"=>$url,"up_emp_id"=>$this->session->userdata('user_id')),'1',$join_array,$order_field,"DESC",'','',''); 
		if(empty($result))
		{ 
		
			$this->load->view('template/default');
		}
		else
		{	
			$condition 				=	array();
			//print_r($this->input->get("consignor_id"));
 			if($this->input->get("consignee_id"))
			{
			
				$condition 				=	array("consignee_id"	=>	$this->input->get("consignee_id"));
				$data['consignee_drpdwn'] =	$this->General_masters_model->select_data(CONSIGNEE_TBL,$select='consignee_id,consignee_name',$condition, $by_row=0, array(),'consignee_name',"ASC",'', 0, null);
						
				 
			}
			$data['table_rows']		=	$this->General_masters_model->get_consigneelist($this->input->get("consignee_id"));
			$data['page_title'] 	=	'Consignee';
		    $data['page_name']  	= 	'consignee/consignee-list';
		    $data['page_master']	= 	'General Masters';
		    $data['page_master_url'] = 	'General_masters/consignee';
		    $data['page_function']	=	'List';
			$this->load->view('template/default', $data);
		}
	}


	//Add Consignee Details
	public function add_consignee()
	{		
		if(!$this->session->userdata('logged_in')) 
			redirect('Login');
		//else
            //redirect('login?goto='."http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]");			
		$url		=	'General_masters/consignee';
		$order_field= 	'add';
		$join_array = 	array(0=>array(0=>USER_PERM_TBL,1=>"up_menu_id=menu_id",2=>''));
		$result 	=	$this->General_masters_model->select_data(MENU_TBL,'*',array("url"=>$url,"up_emp_id"=>$this->session->userdata('user_id')),'1',$join_array,$order_field,"DESC",'','','');
		if(empty($result))
		{
			 
			$this->load->view('template/default');
		}
		else
		{
			$date_format_text =array(0=>"dd/mm/yyyy",1=>"mm/dd/yyyy",2=>"yyyy/mm/dd",3=>"dd-mm-yyyy",4=>"mm-dd-yyyy",5=>"yyyy-mm-dd");
			if ($this->input->post('submit'))
			{	
				
								
				//$data['country_drpdwn'] =	$this->General_masters_model->select_data(COUNTRY_TBL,$select='country_id,name',array("country_id"=>$_POST['consignee_country_id']), $by_row=0, array(),'sortname',"ASC",'', 0, null);
				//$data['state_drpdwn']   =	$this->General_masters_model->select_data(STATE_TBL,$select='state_id,state',array("state_id"=>$_POST['consignee_state_id']), $by_row=0, array(),'state',"ASC",'', 0, null);		
				$this->form_validation->set_error_delimiters('<div style="color:red;text-align:center" class="error"><strong>', '</strong></div>');
				$this->form_validation->set_rules($this->get_consignee_rule(0));
				if ($this->form_validation->run('add_consignee') == true) 
				{
					
					
					
					$insert_array	=	array(	"consignee_name"				=>	$this->input->post("consignee_name"),
												"consignee_addr1"				=>	$this->input->post("consignee_addr1"),
 												"consignee_addr2"				=>	$this->input->post("consignee_addr2"),
												"consignee_addr3"				=>	$this->input->post("consignee_addr3"),
 												"consignee_addr4"				=>	$this->input->post("consignee_addr4"),
												// "consignee_country_id"			=>	$this->input->post("consignee_country_id"),
												// "consignee_state_id"			=>	$this->input->post("consignee_state_id"),
												// "consignee_pin"				    =>	$this->input->post("consignee_pin"),
												"consignee_con_person"			=>	$this->input->post("consignee_con_person"),
												"consignee_con_no"				=>	$this->input->post("consignee_con_no"),
												"consignee_alt_no"				=>	$this->input->post("consignee_alt_no"),
												"consignee_fax"				    =>	$this->input->post("consignee_fax"),
												"consignee_created_date"		=>	date('Y-m-d H:i:s'),
											);
					
						$this->General_masters_model->save_data(CONSIGNEE_TBL,$insert_array,array(),0);
						$this->session->set_flashdata('msg', "Consignee Added Successfully..!");
						redirect('General_masters/consignee');
						
					
				}
				else
				{
					$this->form_validation->set_message('rule', 'Error Message');
				}
			} 
			//$data['ledger_drpdwn'] =	$this->General_masters_model->select_data(LEDGER_TBL,$select='consignor_id,ledger_group_name',array(), $by_row=0, array(),'ledger_group_name',"ASC",'', 0, null);
						
				
			$data['recent_list'] 	=	$this->General_masters_model->get_consignee();
			$data['date_format_text']=	$date_format_text;
			$data['page_title'] 	=	'Consignee';
		    $data['page_name']  	= 	'consignee/add-consignee';
		    $data['page_master']	= 	'General Masters';
		    $data['page_master_url'] = 	'General_masters/consignee';
		    $data['page_function']	=	'Add';
		 	$this->load->view('template/default', $data);
		}
	}




	//Edit Consignee Details
	public function edit_consignee()
	{	
		if(!$this->session->userdata('logged_in')) 
			redirect('Login');
		//else
            //redirect('login?goto='."http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]");
		$url		=	'General_masters/consignee';
		$order_field= 	'edit';
		$join_array = 	array(0=>array(0=>USER_PERM_TBL,1=>"up_menu_id=menu_id",2=>''));
		$result 	=	$this->General_masters_model->select_data(MENU_TBL,'*',array("url"=>$url,"up_emp_id"=>$this->session->userdata('user_id')),'1',$join_array,$order_field,"DESC",'','','');
		if(empty($result))
		{
			
			$this->load->view('template/default');
		}
		else
		{	
			 			
		
		
		$consignee_id 				=	$this->uri->segment(3);
			$data['consignee_id']			=	$consignee_id;
			
			
			$data['edit_consignee']    = 	$this->General_masters_model->select_data(CONSIGNEE_TBL,'*',array("consignee_id"=>$consignee_id),1, array(),'consignee_name',"ASC",'', '','');

			
			$data['recent_list'] 	=	$this->General_masters_model->get_consignee();
								
				
		
		
			 
		
			$consignee_country_id 			=	$data['edit_consignee']->consignee_country_id;
			$consignee_state_id 				=	$data['edit_consignee']->consignee_state_id;
			$data['country_drpdwn'] =	$this->General_masters_model->select_data(COUNTRY_TBL,$select='country_id,name',array("country_id"=>$consignee_country_id), 0, array(),'sortname',"ASC",'', 0, null);
			$data['state_drpdwn']   =	$this->General_masters_model->select_data(STATE_TBL,$select='state_id,state',array("state_id"=>$consignee_state_id),0, array(),'state',"ASC",'', 0, null); 
 			$data['page_title'] 	=	'Consignee';
		    $data['page_name']  	= 	'consignee/edit-consignee';
		    $data['page_master']	= 	'General Masters';
		    $data['page_master_url'] = 	'General_masters/consignee';
		    $data['page_function']	=	'Edit';
			if ($this->input->post('submit'))
			{	
				 
			 				
				//$data['country_drpdwn'] =	$this->General_masters_model->select_data(COUNTRY_TBL,$select='country_id,name',array("country_id"=>$_POST['consignee_country_id']), $by_row=0, array(),'sortname',"ASC",'', 0, null);
				//$data['state_drpdwn']   =	$this->General_masters_model->select_data(STATE_TBL,$select='state_id,state',array("state_id"=>$_POST['consignee_state_id']), $by_row=0, array(),'state',"ASC",'', 0, null);		
				$this->form_validation->set_error_delimiters('<div style="color:red;text-align:center" class="error"><strong>', '</strong></div>');
				$this->form_validation->set_rules($this->get_consignee_rule(1));
				if ($this->form_validation->run('edit_consignee') == true) 
				{
				 
					$insert_array["consignee_name"] 				= $this->input->post("consignee_name");
					$insert_array["consignee_addr1"] 				= $this->input->post("consignee_addr1");
					$insert_array["consignee_addr2"] 				= $this->input->post("consignee_addr2");
					$insert_array["consignee_addr3"] 				= $this->input->post("consignee_addr3");
					$insert_array["consignee_addr4"] 				= $this->input->post("consignee_addr4");
					// $insert_array["consignee_country_id"] 			= $this->input->post("consignee_country_id");
					// $insert_array["consignee_state_id"] 			= $this->input->post("consignee_state_id");
					// $insert_array["consignee_pin"] 			     	= $this->input->post("consignee_pin");
					$insert_array["consignee_con_person"] 			= $this->input->post("consignee_con_person");
					$insert_array["consignee_con_no"] 				= $this->input->post("consignee_con_no");
					$insert_array["consignee_alt_no"] 				= $this->input->post("consignee_alt_no");
					$insert_array["consignee_fax"] 				    = $this->input->post("consignee_fax");
					$insert_array["consignee_created_date"] 		= date('Y-m-d H:i:s');
					
    					
					$consignee_id 		=	$this->input->post("consignee_id");
					$this->General_masters_model->save_data(CONSIGNEE_TBL,$insert_array,array("consignee_id"=>$consignee_id),$consignee_id);
					$this->session->set_flashdata('msg', "Consignee Updated Successfully..!");
					redirect('General_masters/consignee');					
				}
				else
				{
					$this->form_validation->set_message('rule', 'Error Message');
				}
			}
		}
		$this->load->view('template/default', $data);
	}


	public function notify()	

	{  
		if(!$this->session->userdata('logged_in')) 
			redirect('Login');
		//else
            //redirect('login?goto='."http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]");
		$url		=	'General_masters/notify';
		$order_field= 	'view';
		$join_array = 	array(0=>array(0=>USER_PERM_TBL,1=>"up_menu_id=menu_id",2=>''));
		$result 	=	$this->General_masters_model->select_data(MENU_TBL,'*',array("url"=>$url,"up_emp_id"=>$this->session->userdata('user_id')),'1',$join_array,$order_field,"DESC",'','',''); 
		if(empty($result))
		{ 
		
			$this->load->view('template/default');
		}
		else
		{	
			$condition 				=	array();
			//print_r($this->input->get("consignor_id"));
 			if($this->input->get("notify_id"))
			{
			
				$condition 				=	array("notify_id"	=>	$this->input->get("notify_id"));
				$data['notify_drpdwn'] =	$this->General_masters_model->select_data(NOTIFY_TBL,$select='notify_id,notify_name',$condition, $by_row=0, array(),'notify_name',"ASC",'', 0, null);
						
				 
			}
			$data['table_rows']		=	$this->General_masters_model->get_notifylist($this->input->get("notify_id"));
			$data['page_title'] 	=	'Notify';
		    $data['page_name']  	= 	'notify/notify-list';
		    $data['page_master']	= 	'General Masters';
		    $data['page_master_url'] = 	'General_masters/notify';
		    $data['page_function']	=	'List';
			$this->load->view('template/default', $data);
		}
	}


	//Add Notify Details
	public function add_notify()
	{		
		if(!$this->session->userdata('logged_in')) 
			redirect('Login');
		//else
            //redirect('login?goto='."http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]");			
		$url		=	'General_masters/notify';
		$order_field= 	'add';
		$join_array = 	array(0=>array(0=>USER_PERM_TBL,1=>"up_menu_id=menu_id",2=>''));
		$result 	=	$this->General_masters_model->select_data(MENU_TBL,'*',array("url"=>$url,"up_emp_id"=>$this->session->userdata('user_id')),'1',$join_array,$order_field,"DESC",'','','');
		if(empty($result))
		{
			 
			$this->load->view('template/default');
		}
		else
		{
			$date_format_text =array(0=>"dd/mm/yyyy",1=>"mm/dd/yyyy",2=>"yyyy/mm/dd",3=>"dd-mm-yyyy",4=>"mm-dd-yyyy",5=>"yyyy-mm-dd");
			if ($this->input->post('submit'))
			{	
				
								
				//$data['country_drpdwn'] =	$this->General_masters_model->select_data(COUNTRY_TBL,$select='country_id,name',array("country_id"=>$_POST['notify_country_id']), $by_row=0, array(),'sortname',"ASC",'', 0, null);
				//$data['state_drpdwn']   =	$this->General_masters_model->select_data(STATE_TBL,$select='state_id,state',array("state_id"=>$_POST['notify_state_id']), $by_row=0, array(),'state',"ASC",'', 0, null);		
				$this->form_validation->set_error_delimiters('<div style="color:red;text-align:center" class="error"><strong>', '</strong></div>');
				// $this->form_validation->set_rules($this->get_notify_rule(0));
				// if ($this->form_validation->run('add_notify') == true) 
				// {
					
					
					
					$insert_array	=	array(	"notify_name"				=>	$this->input->post("notify_name"),
												"notify_addr1"				=>	$this->input->post("notify_addr1"),
 												"notify_addr2"				=>	$this->input->post("notify_addr2"),
												"notify_addr3"				=>	$this->input->post("notify_addr3"),
 												"notify_addr4"				=>	$this->input->post("notify_addr4"),
												// "notify_country_id"			=>	$this->input->post("notify_country_id"),
												// "notify_state_id"			=>	$this->input->post("notify_state_id"),
												// "notify_pin"				    =>	$this->input->post("notify_pin"),
												"notify_con_person"			=>	$this->input->post("notify_con_person"),
												"notify_con_no"				=>	$this->input->post("notify_con_no"),
												"notify_alt_no"				=>	$this->input->post("notify_alt_no"),
												"notify_fax"				    =>	$this->input->post("notify_fax"),
												"notify_created_date"		=>	date('Y-m-d H:i:s'),
											);
					
						$this->General_masters_model->save_data(NOTIFY_TBL,$insert_array,array(),0);
						$this->session->set_flashdata('msg', "Notify Added Successfully..!");
						redirect('General_masters/notify');
						
					
				// }
				// else
				// {
				// 	$this->form_validation->set_message('rule', 'Error Message');
				// }
			} 
			//$data['ledger_drpdwn'] =	$this->General_masters_model->select_data(LEDGER_TBL,$select='consignor_id,ledger_group_name',array(), $by_row=0, array(),'ledger_group_name',"ASC",'', 0, null);
						
				
			$data['recent_list'] 	=	$this->General_masters_model->get_notify();
			$data['date_format_text']=	$date_format_text;
			$data['page_title'] 	=	'Notify';
		    $data['page_name']  	= 	'notify/add-notify';
		    $data['page_master']	= 	'General Masters';
		    $data['page_master_url'] = 	'General_masters/notify';
		    $data['page_function']	=	'Add';
		 	$this->load->view('template/default', $data);
		}
	}




	//Edit Notify Details
	public function edit_notify()
	{	
		if(!$this->session->userdata('logged_in')) 
			redirect('Login');
		//else
            //redirect('login?goto='."http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]");
		$url		=	'General_masters/notify';
		$order_field= 	'edit';
		$join_array = 	array(0=>array(0=>USER_PERM_TBL,1=>"up_menu_id=menu_id",2=>''));
		$result 	=	$this->General_masters_model->select_data(MENU_TBL,'*',array("url"=>$url,"up_emp_id"=>$this->session->userdata('user_id')),'1',$join_array,$order_field,"DESC",'','','');
		if(empty($result))
		{
			
			$this->load->view('template/default');
		}
		else
		{	
			 			
		
		
		$notify_id 				=	$this->uri->segment(3);
			$data['notify_id']			=	$notify_id;
			
			
			$data['edit_notify']    = 	$this->General_masters_model->select_data(NOTIFY_TBL,'*',array("notify_id"=>$notify_id),1, array(),'notify_name',"ASC",'', '','');

			
			$data['recent_list'] 	=	$this->General_masters_model->get_notify();
								
				
		
		
			 
		
			//$notify_country_id 			=	$data['edit_notify']->notify_country_id;
			//$notify_state_id 				=	$data['edit_notify']->notify_state_id;
			//$data['country_drpdwn'] =	$this->General_masters_model->select_data(COUNTRY_TBL,$select='country_id,name',array("country_id"=>$notify_country_id), 0, array(),'sortname',"ASC",'', 0, null);
			//$data['state_drpdwn']   =	$this->General_masters_model->select_data(STATE_TBL,$select='state_id,state',array("state_id"=>$notify_state_id),0, array(),'state',"ASC",'', 0, null); 
 			$data['page_title'] 	=	'Notify';
		    $data['page_name']  	= 	'notify/edit-notify';
		    $data['page_master']	= 	'General Masters';
		    $data['page_master_url'] = 	'General_masters/notify';
		    $data['page_function']	=	'Edit';
			if ($this->input->post('submit'))
			{	
				 
			 				
				$data['country_drpdwn'] =	$this->General_masters_model->select_data(COUNTRY_TBL,$select='country_id,name',array("country_id"=>$_POST['notify_country_id']), $by_row=0, array(),'sortname',"ASC",'', 0, null);
				$data['state_drpdwn']   =	$this->General_masters_model->select_data(STATE_TBL,$select='state_id,state',array("state_id"=>$_POST['notify_state_id']), $by_row=0, array(),'state',"ASC",'', 0, null);		
				$this->form_validation->set_error_delimiters('<div style="color:red;text-align:center" class="error"><strong>', '</strong></div>');
				// $this->form_validation->set_rules($this->get_notify_rule(1));
				// if ($this->form_validation->run('edit_notify') == true) 
				// {
				 
					$insert_array["notify_name"] 				= $this->input->post("notify_name");
					$insert_array["notify_addr1"] 				= $this->input->post("notify_addr1");
					$insert_array["notify_addr2"] 				= $this->input->post("notify_addr2");
					$insert_array["notify_addr3"] 				= $this->input->post("notify_addr3");
					$insert_array["notify_addr4"] 				= $this->input->post("notify_addr4");
					// $insert_array["notify_country_id"] 			= $this->input->post("notify_country_id");
					// $insert_array["notify_state_id"] 			= $this->input->post("notify_state_id");
					// $insert_array["notify_pin"] 			     	= $this->input->post("notify_pin");
					$insert_array["notify_con_person"] 			= $this->input->post("notify_con_person");
					$insert_array["notify_con_no"] 				= $this->input->post("notify_con_no");
					$insert_array["notify_alt_no"] 				= $this->input->post("notify_alt_no");
					$insert_array["notify_fax"] 				    = $this->input->post("notify_fax");
					$insert_array["notify_created_date"] 		= date('Y-m-d H:i:s');
					
    					
					$notify_id 		=	$this->input->post("notify_id");
					$this->General_masters_model->save_data(NOTIFY_TBL,$insert_array,array("notify_id"=>$notify_id),$notify_id);
					$this->session->set_flashdata('msg', "Notify Address Updated Successfully..!");
					redirect('General_masters/notify');					
				// }
				// else
				// {
				// 	$this->form_validation->set_message('rule', 'Error Message');
				// }
			}
		}
		$this->load->view('template/default', $data);
	}


public function port_of_dis()
	{  
		if(!$this->session->userdata('logged_in')) 
			redirect('Login');
		//else
            //redirect('login?goto='."http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]");
		$url		=	'General_masters/port_of_dis';
		$order_field= 	'view';
		$join_array = 	array(0=>array(0=>USER_PERM_TBL,1=>"up_menu_id=menu_id",2=>''));
		$result 	=	$this->General_masters_model->select_data(MENU_TBL,'*',array("url"=>$url,"up_emp_id"=>$this->session->userdata('user_id')),'1',$join_array,$order_field,"DESC",'','','');
		if(empty($result))
		{
			$data['page_title'] 	=	'Warning';
	        $data['page_name']  	= 	'warning';
	        $data['page_master']	= 	'Dashboard';
	        $data['page_master_url'] = 	'Dashboard';
	        $data['page_function']	=	'';
			$this->load->view('template/default', $data);
		}
		else
		{	
			$condition 				=	array();
			if($this->input->get("port_of_dis_id"))
			{
				$condition 				=	array("port_of_dis_id"	=>	$this->input->get("port_of_dis_id"));
				$data['port_of_dis_drpdwn'] =	$this->General_masters_model->select_data(PORT_TBL,$select='port_of_dis_id,port_of_dis_name',$condition, $by_row=0, array(),'port_of_dis_name',"ASC",'', 0, null);		
			}
			$data['table_rows']		=	$this->General_masters_model->select_data(PORT_TBL,$select='port_of_dis_id,port_of_dis_name,port_of_dis_shrt_code',$condition, $by_row=0, array(),'port_of_dis_id',"DESC",'', 0, null);
			$data['page_title'] 	=	'Port of discharge';
		    $data['page_name']  	= 	'port_of_dis/port_of_dis-lists';
		    $data['page_master']	= 	'General Masters';
		    $data['page_master_url'] = 	'General_masters/port_of_dis';
		    $data['page_function']	=	'List';
			$this->load->view('template/default', $data);
		}
	}


	public function add_port_of_dis()
	{		
		if(!$this->session->userdata('logged_in')) 
			redirect('Login');
		//else
            //redirect('login?goto='."http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]");			
		$url		=	'General_masters/port_of_dis';
		$order_field= 	'add';
		$join_array = 	array(0=>array(0=>USER_PERM_TBL,1=>"up_menu_id=menu_id",2=>''));
		$result 	=	$this->General_masters_model->select_data(MENU_TBL,'*',array("url"=>$url,"up_emp_id"=>$this->session->userdata('user_id')),'1',$join_array,$order_field,"DESC",'','','');
		if(empty($result))
		{
			$data['page_title'] 	=	'Warning';
	        $data['page_name']  	= 	'warning';
	        $data['page_master']	= 	'Dashboard';
	        $data['page_master_url'] = 	'Dashboard';
	        $data['page_function']	=	'';
			$this->load->view('template/default', $data);
		}
		else
		{
			$date_format_text =array(0=>"dd/mm/yyyy",1=>"mm/dd/yyyy",2=>"yyyy/mm/dd",3=>"dd-mm-yyyy",4=>"mm-dd-yyyy",5=>"yyyy-mm-dd");
			if ($this->input->post('submit'))
			{	
				//$data['country_drpdwn'] =	$this->General_masters_model->select_data(COUNTRY_TBL,$select='country_id,name',array("country_id"=>$_POST['cmp_country']), $by_row=0, array(),'sortname',"ASC",'', 0, null);
				//$data['state_drpdwn']   =	$this->General_masters_model->select_data(STATE_TBL,$select='state_id,state',array("state_id"=>$_POST['cmp_state']), $by_row=0, array(),'state',"ASC",'', 0, null);					
				//$data['currency_drpdwn']=	$this->General_masters_model->select_data(CURRENCY_TBL,$select='currency_id,currency,currency_code',array("currency_id"=>$_POST['cmp_currency']), $by_row=0, array(),'currency',"ASC",'', 0, null);					
				$this->form_validation->set_error_delimiters('<div style="color:red;text-align:center" class="error"><strong>', '</strong></div>');
				$this->form_validation->set_rules($this->get_port_of_dis_rule(0));
				if ($this->form_validation->run('add_port_of_dis') == true) 
				{
					$config['upload_path']   = 'uploads/port_of_dis/';
					$config['allowed_types'] = 'gif|jpg|png';
					$config['max_size']		 = '5000';
					$config['max_width']  	 = '10240';
					$config['max_height']    = '7680';
					$this->load->library('upload', $config);
					$logo_name			 	 = "";
					if ($this->upload->do_upload('cmp_logo'))
					{
						$upload_data	=	$this->upload->data();
						$logo_name   	= 	$upload_data['file_name'];

						$config['overwrite'] 		= TRUE;
						$config['image_library'] 	= 'gd2';
                    	$config['source_image'] 	= $this->upload->upload_path.$this->upload->file_name;
                    	$config['maintain_ratio'] 	= TRUE;
                    	$config['width'] 			= 550;
                    	$config['height'] 			= 550;
                    	$this->load->library('image_lib',$config); 

                    	if ( !$this->image_lib->resize())
                    	{
               				$this->session->set_flashdata('error', $this->image_lib->display_errors('', ''));   
             			}
					}
					$insert_array	=	array(	"port_of_dis_name"				=>	$this->input->post("port_of_dis_name"),
												"port_of_dis_shrt_code"				=>	$this->input->post("port_of_dis_shrt_code"),
												"port_of_dis_created_date"		=>	date('Y-m-d H:i:s')
											);
						$this->General_masters_model->save_data(PORT_TBL,$insert_array,array(),0);
						$this->session->set_flashdata('msg', "Port of Discharge Added Successfully..!");
						redirect('General_masters/port_of_dis');
					
				}
				else
				{
					$this->form_validation->set_message('rule', 'Error Message');
				}
			}
			$data['recent_list'] 	=	$this->General_masters_model->select_data(PORT_TBL,$select='port_of_dis_id,port_of_dis_name,port_of_dis_shrt_code',array(), $by_row=0, array(),'port_of_dis_id',"DESC",'', 10,0);
			$data['date_format_text']=	$date_format_text;
			$data['page_title'] 	=	'Port of Discharge';
		    $data['page_name']  	= 	'port_of_dis/add-port_of_dis';
		    $data['page_master']	= 	'General Masters';
		    $data['page_master_url'] = 	'General_masters/port_of_dis';
		    $data['page_function']	=	'Add';
			$this->load->view('template/default', $data);
		}
	}

	public function edit_port_of_dis()
	{	
		if(!$this->session->userdata('logged_in')) 
			redirect('Login');
		//else
            //redirect('login?goto='."http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]");
		$url		=	'General_masters/port_of_dis';
		$order_field= 	'edit';
		$join_array = 	array(0=>array(0=>USER_PERM_TBL,1=>"up_menu_id=menu_id",2=>''));
		$result 	=	$this->General_masters_model->select_data(MENU_TBL,'*',array("url"=>$url,"up_emp_id"=>$this->session->userdata('user_id')),'1',$join_array,$order_field,"DESC",'','','');
		if(empty($result))
		{
			$data['page_title'] 	=	'Warning';
	        $data['page_name']  	= 	'warning';
	        $data['page_master']	= 	'Dashboard';
	        $data['page_master_url'] = 	'Dashboard';
	        $data['page_function']	=	'';
			$this->load->view('template/default', $data);
		}
		else
		{	
			$date_format_text =array(0=>"dd/mm/yyyy",1=>"mm/dd/yyyy",2=>"yyyy/mm/dd",3=>"dd-mm-yyyy",4=>"mm-dd-yyyy",5=>"yyyy-mm-dd");			
		
			$port_of_dis_id 				=	$this->uri->segment(3);
			$data['port_of_dis_id']			=	$port_of_dis_id;
			$data['edit_port_of_dis']   = 	$this->General_masters_model->select_data(PORT_TBL,'*',array("port_of_dis_id"=>$port_of_dis_id),	1, array(),'port_of_dis_name',"ASC",'', '','');
			//$cmp_country 			=	$data['edit_company']->cmp_country;
			//$cmp_state 				=	$data['edit_company']->cmp_state;
			//$cmp_currency 			=	$data['edit_company']->cmp_currency;
			$data['recent_list'] 	=	$this->General_masters_model->select_data(PORT_TBL,$select='port_of_dis_id,port_of_dis_name,port_of_dis_shrt_code',array(), 0, array(),'port_of_dis_id',"DESC",'', 10,0);
			//$data['country_drpdwn'] =	$this->General_masters_model->select_data(COUNTRY_TBL,$select='country_id,name',array("country_id"=>$cmp_country), 0, array(),'sortname',"ASC",'', 0, null);
			//$data['state_drpdwn']   =	$this->General_masters_model->select_data(STATE_TBL,$select='state_id,state',array("state_id"=>$cmp_state),0, array(),'state',"ASC",'', 0, null);
			//$data['currency_drpdwn']=	$this->General_masters_model->select_data(CURRENCY_TBL,$select='currency_id,currency,currency_code',array("currency_id"=>$cmp_currency), $by_row=0, array(),'currency',"ASC",'', 0, null);		
			$data['date_format_text']=	$date_format_text;
			$data['page_title'] 	=	'Port of Discharge';
		    $data['page_name']  	= 	'port_of_dis/edit-port_of_dis';
		    $data['page_master']	= 	'General Masters';
		    $data['page_master_url'] = 	'General_masters/port_of_dis';
		    $data['page_function']	=	'Edit';
			if ($this->input->post('submit'))
			{	
				//$data['country_drpdwn'] =	$this->General_masters_model->select_data(COUNTRY_TBL,$select='country_id,name',array("country_id"=>$_POST['cmp_country']), $by_row=0, array(),'sortname',"ASC",'', 0, null);
				//$data['state_drpdwn']   =	$this->General_masters_model->select_data(STATE_TBL,$select='state_id,state',array("state_id"=>$_POST['cmp_state']), $by_row=0, array(),'state',"ASC",'', 0, null);					
				//$data['currency_drpdwn']=	$this->General_masters_model->select_data(CURRENCY_TBL,$select='currency_id,currency,currency_code',array("currency_id"=>$_POST['cmp_currency']), $by_row=0, array(),'currency',"ASC",'', 0, null);					
				$this->form_validation->set_error_delimiters('<div style="color:red;text-align:center" class="error"><strong>', '</strong></div>');
				$this->form_validation->set_rules($this->get_port_of_dis_rule(1));
				if ($this->form_validation->run('edit_port_of_dis') == true) 
				{
					$config['upload_path']   = 'uploads/port_of_dis/';
					$config['allowed_types'] = 'gif|jpg|png';
					$config['max_size']		 = '5000';
					$config['max_width']  	 = '10240';
					$config['max_height']    = '7680';
					$this->load->library('upload', $config);
					$logo_name			 	 = "";
					if ($this->upload->do_upload('cmp_logo'))
					{
						$upload_data	 =	$this->upload->data();
						$logo_name   	 = 	$upload_data['file_name'];
						$insert_array['cmp_logo']=	$logo_name;

						$config['overwrite'] 		= TRUE;
						$config['image_library'] 	= 'gd2';
                    	$config['source_image'] 	= $this->upload->upload_path.$this->upload->file_name;
                    	$config['maintain_ratio'] 	= TRUE;
                    	$config['width'] 			= 550;
                    	$config['height'] 			= 550;
                    	$this->load->library('image_lib',$config); 

                    	if ( !$this->image_lib->resize())
                    	{
               				$this->session->set_flashdata('error', $this->image_lib->display_errors('', ''));   
             			}
					}
					$insert_array["port_of_dis_name"] 				=		$this->input->post("port_of_dis_name");
					$insert_array["port_of_dis_shrt_code"]				=		$this->input->post("port_of_dis_shrt_code");
					
					
					$port_of_dis_id 		=	$this->input->post("port_of_dis_id");
					$this->General_masters_model->save_data(PORT_TBL,$insert_array,array("port_of_dis_id"=>$port_of_dis_id),$port_of_dis_id);
					$this->session->set_flashdata('msg', "Port of Discharge Updated Successfully..!");
					redirect('General_masters/port_of_dis');					
				}
				else
				{
					$this->form_validation->set_message('rule', 'Error Message');
				}
			}
		}
		$this->load->view('template/default', $data);
	}






















/*-----------------------------------------Ledger------------------------------------*/
public function ledger()
	{  
		if(!$this->session->userdata('logged_in')) 
			redirect('Login');
		//else
            //redirect('login?goto='."http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]");
		$url		=	'General_masters/Ledger';
		$order_field= 	'view';
		$join_array = 	array(0=>array(0=>USER_PERM_TBL,1=>"up_menu_id=menu_id",2=>''));
		$result 	=	$this->General_masters_model->select_data(MENU_TBL,'*',array("url"=>$url,"up_emp_id"=>$this->session->userdata('user_id')),'1',$join_array,$order_field,"DESC",'','',''); 
		if(empty($result))
		{ 
		
			$this->load->view('template/default');
		}
		else
		{	
			$condition 				=	array();
		 print_r($this->input->get("ledger_master_id"));
			 
 			if($this->input->get("ledger_master_id"))
			{
			
				$condition 				=	array("ledger_master_id"	=>	$this->input->get("ledger_master_id"));
				$data['ledger_mast_drpdwn'] =	$this->General_masters_model->select_data(LEDGERMASTER_TBL,$select='ledger_master_id,ledger_name',$condition, $by_row=0, array(),'ledger_name',"ASC",'', 0, null);
			 
						
				 
			}
			
			if($this->input->get("ledger_group_id"));
			{
			
				$condition 				=	array("ledger_master_id"	=>	$this->input->get("ledger_group_id"));
				$data['ledger_mast_drpdwn'] =	$this->General_masters_model->select_data(LEDGERMASTER_TBL,$select='ledger_master_id,ledger_name',$condition, $by_row=0, array(),'ledger_name',"ASC",'', 0, null);
			
			}
			
			
			$data['ledger_group_id']              = $this->input->get("ledger_group_id");
			$this->General_masters_model->use_table("ledgergroup");
			$ledger_details = $this->General_masters_model->get_one_where(array('ledger_group_id'=>$data['ledger_group_id']));
			
			$data['ledger_group_name']              = $ledger_details->ledger_group_name;
			
			
			
			$data['ledger_master_id']              = $this->input->get("ledger_master_id");
			$this->General_masters_model->use_table("ledger");
			$ledger_master_details = $this->General_masters_model->get_one_where(array('ledger_master_id'=>$data['ledger_master_id']));
			$data['ledger_name']              = $ledger_master_details->ledger_name;
			
		    $data['table_rows']		=	$this->General_masters_model->get_ledger_list($this->input->get("ledger_master_id"),$this->input->get("ledger_group_id"));  
			//$data['table_rows']		=	$this->General_masters_model->get_ledger($this->input->get("ledger_master_id"));
			$data['page_title'] 	=	'Ledger';
		    $data['page_name']  	= 	'Ledger/ledger-lists';
		    $data['page_master']	= 	'General Masters';
		    $data['page_master_url'] = 	'General_masters/Ledger';
		    $data['page_function']	=	'List';
			$this->load->view('template/default', $data);
		}
	}
////////addledger///////////////////////////////////////////////////////////////////
	public function add_ledger()
	{		
		if(!$this->session->userdata('logged_in')) 
			redirect('Login');
		//else
            //redirect('login?goto='."http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]");			
		$url		=	'General_masters/LedgerGroup';
		$order_field= 	'add';
		$join_array = 	array(0=>array(0=>USER_PERM_TBL,1=>"up_menu_id=menu_id",2=>''));
		$result 	=	$this->General_masters_model->select_data(MENU_TBL,'*',array("url"=>$url,"up_emp_id"=>$this->session->userdata('user_id')),'1',$join_array,$order_field,"DESC",'','','');
		if(empty($result))
		{
			 
			$this->load->view('template/default');
		}
		else
		{
			$ladeger_type_data =array(0=>"Dept",1=>"Credit");
			$account_type_data =array(0=>"Bank",1=>"Cash");
			if ($this->input->post('submit'))
			{	
				
								
						
				$this->form_validation->set_error_delimiters('<div style="color:red;text-align:center" class="error"><strong>', '</strong></div>');
				$this->form_validation->set_rules($this->get_ledger_rule(0));
				if ($this->form_validation->run('add_ledge') == true) 
				{
					
					$recom =  $this->input->post("reconciliation");
					if($recom  == ""){ $recom =0;}else { $recom =1;}
					
					$insert_array	=	array(	"ledger_name"				    =>	$this->input->post("ledger_name"),
												"parent_ledger_group_id"	    =>	$this->input->post("parent_ledger_group_id"),
												"ledger_type"		            =>	$this->input->post("ledger_type"),
												"opening_balance"		        =>	$this->input->post("opening_balance"),
												"account_type"		            =>	$this->input->post("account_type"),
 												"reconciliation"		        =>	$recom,
 												"ledgre_notes"		            =>	$this->input->post("ledgre_notes"),
												"ledger_company_id"		        =>	$this->input->post("ledger_company_id"),
												"ledger_branch_id"              =>  $this->input->post("ledger_branch_id"),
 												"createdby"		                =>	$this->session->userdata('user_id'),
												"created_date_time"		        =>	date('Y-m-d H:i:s'),
												"delete_status"		            =>	0
											);
						$this->General_masters_model->save_data(LEDGERMASTER_TBL,$insert_array,array(),0);
						$this->session->set_flashdata('msg', "Ledger Added Successfully..!");
						redirect('General_masters/Ledger');
						
					
				}
				else
				{
					$this->form_validation->set_message('rule', 'Error Message');
				}
			} 
				$data['ledger_drpdwn'] =	$this->General_masters_model->select_data(LEDGER_TBL,$select='ledger_group_id,ledger_group_name',array(), $by_row=0, array(),'ledger_group_name',"ASC",'', 0, null);
				$data['company_drpdwn'] =	$this->General_masters_model->select_data(COMPANY_TBL,$select='cmp_id,cmp_name',array(), $by_row=0, array(),'cmp_name',"ASC",'', 0, null);
				$data['branch_drpdwn'] =	$this->General_masters_model->select_data(BRANCH_TBL,$select='branch_id,branch_name',array(), $by_row=0, array(),'branch_name',"ASC",'', 0, null);     
				$data['ladeger_type_data']=	$ladeger_type_data;
				$data['account_type_data']= $account_type_data;
				
				 // echo $this->db->last_query();
				 //exit();
			$data['recent_list'] 	=	$this->General_masters_model->get_ledger();
			$data['ledger_type']    =	$ladeger_type_data;
			$data['page_title'] 	=	'Ledger';
		    $data['page_name']  	= 	'Ledger/add-ledger';
		    $data['page_master']	= 	'General Masters';
		    $data['page_master_url'] = 	'General_masters/Ledger';
		    $data['page_function']	=	'Add';
		 	$this->load->view('template/default', $data);
		}
	}

////Edit Ledger Details
  	public function edit_ledger()
	{	
		if(!$this->session->userdata('logged_in')) 
			redirect('Login');
		//else
            //redirect('login?goto='."http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]");
		$url		=	'General_masters/Ledger';
		$order_field= 	'edit';
		$join_array = 	array(0=>array(0=>USER_PERM_TBL,1=>"up_menu_id=menu_id",2=>''));
		$result 	=	$this->General_masters_model->select_data(MENU_TBL,'*',array("url"=>$url,"up_emp_id"=>$this->session->userdata('user_id')),'1',$join_array,$order_field,"DESC",'','','');
		if(empty($result))
		{
			
			$this->load->view('template/default');
		}
		else
		{	
			 			
		
		
		    $ledger_master_id 				    =	$this->uri->segment(3);
			$data['ledger_master_id']			=	$ledger_master_id;
			 
			$data['edit_ledger']    = 	$this->General_masters_model->select_data(LEDGERMASTER_TBL,'*',array("ledger_master_id"=>$ledger_master_id),1, array(),'ledger_name',"ASC",'', '','');
			$parent_ledger_group_id 			=	$data['edit_ledger']->parent_ledger_group_id;
			
			 $data['recent_list'] 	=	$this->General_masters_model->get_ledger();
		
			$data['ledger_drpdwn'] =	$this->General_masters_model->select_data(LEDGER_TBL,$select='ledger_group_id,ledger_group_name,parent_id',array(), $by_row=0, array(),'ledger_group_name',"ASC",'', 0, null);
			$data['company_drpdwn'] =	$this->General_masters_model->select_data(COMPANY_TBL,$select='cmp_id,cmp_name',array(), $by_row=0, array(),'cmp_name',"ASC",'', 0, null);
			$data['branch_drpdwn'] =	$this->General_masters_model->select_data(BRANCH_TBL,$select='branch_id,branch_name',array(), $by_row=0, array(),'branch_name',"ASC",'', 0, null);     $ladeger_type_data =array(0=>"Dept",1=>"Credit");
			$account_type_data =array(0=>"Bank",1=>"Cash");
			$data['ladeger_type_data']=	$ladeger_type_data;
				$data['account_type_data']= $account_type_data;
				
			 
				$data['parent_ledger_group_id']			=	$parent_ledger_group_id;
				 
		
			 
			  //echo $this->db->last_query();
			 
 			$data['page_title'] 	=	'Ledger';
		    $data['page_name']  	= 	'Ledger/edit-ledger';
		    $data['page_master']	= 	'General Masters';
		    $data['page_master_url'] = 	'General_masters/Ledger';
		    $data['page_function']	=	'Edit';
			if ($this->input->post('submit'))
			{	
				 
			 				
				 		
				$this->form_validation->set_error_delimiters('<div style="color:red;text-align:center" class="error"><strong>', '</strong></div>');
				$this->form_validation->set_rules($this->get_ledger_rule(1));
				if ($this->form_validation->run('edit_ledger') == true) 
				{
				 
				    $recom =  $this->input->post("reconciliation");
					if($recom  == ""){ $recom =0;}else { $recom =1;}
					
					
					$insert_array["ledger_name"] 		    =		$this->input->post("ledger_name");
					$insert_array["parent_ledger_group_id"]	=		$this->input->post("parent_ledger_group_id");
					$insert_array["ledger_type"] 		    =		$this->input->post("ledger_type");
					$insert_array["opening_balance"]		=		$this->input->post("opening_balance");
					$insert_array["account_type"] 			=       $this->input->post("account_type");
					$insert_array["reconciliation"]			=		$recom;
					$insert_array["ledgre_notes"] 		    =		$this->input->post("ledgre_notes");
					$insert_array["ledger_company_id"]		=		$this->input->post("ledger_company_id");
					$insert_array["ledger_branch_id"] 		=		$this->input->post("ledger_branch_id");
     				$ledger_master_id 		                =	    $this->input->post("ledger_master_id");
    					
					
					$this->General_masters_model->save_data(LEDGERMASTER_TBL,$insert_array,array("ledger_master_id"=>$ledger_master_id),$ledger_master_id);
					$this->session->set_flashdata('msg', "Ledger  Updated Successfully..!");
					redirect('General_masters/ledger');					
				}
				else
				{
					$this->form_validation->set_message('rule', 'Error Message');
				}
			}
		}
		$this->load->view('template/default', $data);
	}
/*----------------------Bank Details------------------------- */

public function bank()
	{  
		if(!$this->session->userdata('logged_in')) 
			redirect('Login');
		//else
            //redirect('login?goto='."http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]");
		$url		=	'General_masters/Bank';
		$order_field= 	'view';
		$join_array = 	array(0=>array(0=>USER_PERM_TBL,1=>"up_menu_id=menu_id",2=>''));
		$result 	=	$this->General_masters_model->select_data(MENU_TBL,'*',array("url"=>$url,"up_emp_id"=>$this->session->userdata('user_id')),'1',$join_array,$order_field,"DESC",'','',''); 
		if(empty($result))
		{ 
			$this->load->view('template/default');
		}
		else
		{	
			$condition 				=	array();
			 
 			if($this->input->get("bank_id"))
			{
			$condition 				=	array("bank_id"	=>	$this->input->get("bank_id"));
			$data['bank_drpdwn'] =	$this->General_masters_model->select_data(BANK_TBL,$select='bank_id,bank_name',$condition, $by_row=0, array(),'bank_name',"ASC",'', 0, null);
			}
		    $data['table_rows']		  =	$this->General_masters_model->get_banklist($this->input->get("bank_id"));
 			$data['page_title'] 	=	'Bank';
		    $data['page_name']  	= 	'bank/bank-list';
		    $data['page_master']	= 	'General Masters';
		    $data['page_master_url'] = 	'General_masters/Bank';
		    $data['page_function']	=	'list';
			 
			$this->load->view('template/default', $data);
		}
	}
	
	
		//Add Bank  Details
	public function add_bank()
	{	
 		if(!$this->session->userdata('logged_in')) 
			redirect('Login');
		//else
            //redirect('login?goto='."http://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]");			
		$url		=	'General_masters/Bank';
		$order_field= 	'add';
		$join_array = 	array(0=>array(0=>USER_PERM_TBL,1=>"up_menu_id=menu_id",2=>''));
		$result 	=	$this->General_masters_model->select_data(MENU_TBL,'*',array("url"=>$url,"up_emp_id"=>$this->session->userdata('user_id')),'1',$join_array,$order_field,"DESC",'','','');
		if(empty($result))
		{
			 
			$this->load->view('template/default');
		}
		else
		{
			$date_format_text =array(0=>"dd/mm/yyyy",1=>"mm/dd/yyyy",2=>"yyyy/mm/dd",3=>"dd-mm-yyyy",4=>"mm-dd-yyyy",5=>"yyyy-mm-dd");
			if ($this->input->post('submit'))
			{	
				
								
						
				$this->form_validation->set_error_delimiters('<div style="color:red;text-align:center" class="error"><strong>', '</strong></div>');
				$this->form_validation->set_rules($this->get_ledgergroup_rule(0));
				if ($this->form_validation->run('add_bank') == true) 
				{
					
					
					
					$insert_array	=	array(	"ledger_group_name"				=>	$this->input->post("ledger_group_name"),
												"parent_id"				        =>	$this->input->post("parent_id"),
 												"createdby"		                =>	$this->session->userdata('user_id'),
												"created_date_time"		        =>	date('Y-m-d H:i:s'),
												"delete_status"		            =>	1
											);
						$this->General_masters_model->save_data(LEDGER_TBL,$insert_array,array(),0);
						$this->session->set_flashdata('msg', "Bank Added Successfully..!");
						redirect('General_masters/bank');
						
					
				}
				else
				{
					$this->form_validation->set_message('rule', 'Error Message');
				}
			} 
			//$condition 				=	array("bank_id"	=>	$this->input->get("bank_id"));
				//$data['bank_drpdwn'] =	$this->General_masters_model->select_data(BANK_TBL,$select='bank_id,bank_name',$condition, $by_row=0, array(),'bank_name',"ASC",'', 0, null); 
			 //$data['recent_list'] 	=	$this->General_masters_model->get_banklist();
			$data['date_format_text']=	$date_format_text;
		    $data['page_title'] 	=	'Bank';
		    $data['page_name']  	= 	'bank/add-bank';
		    $data['page_master']	= 	'General Masters';
		    $data['page_master_url'] = 	'General_masters/bank';
		    $data['page_function']	=	'Add';
  		 	$this->load->view('template/default', $data);
		}
	}

	//Select country
	public function get_countries()
	{
		$entered_str 	=	$this->input->get("q");
		echo $this->General_masters_model->get_countries($entered_str);
	}
	//Select state on change of country
	public function get_state_by_country()
	{
		$entered_str 	=	$this->input->get("q");
		$country_id 	=	$this->input->get("country_id");
		echo $this->General_masters_model->get_state_by_country($entered_str,$country_id);
	}


	public function addProduct()
    {		

		if ($this->input->post('submit'))
		{	

			$this->form_validation->set_error_delimiters('<div style="color:red;text-align:center" class="error"><strong>', '</strong></div>');
			$this->form_validation->set_rules($this->get_product_rule(0)); 

			if ($this->form_validation->run('addProduct') == true) 
			{  

				
				$pdt_name          =     $this->input->post("product_name");				
				$product           =     array(
					"product"      =>    $this->input->post("product_name"),
					"description"  =>    $this->input->post("description"),
					"price"        =>    $this->input->post("price"),
					"taxType"      =>    $this->input->post("tax_class_id"),
					"hsn_sac"      =>    $this->input->post("hsn"),
					"created_by"   =>    $this->session->userdata('user_id'),
					"created_date" =>    date('Y-m-d H:i:s'),
					"status"       =>    0
				);
				// echo "<pre>";
				// die(print_r($product));


				$prd_id            = $this->General_masters_model->save_data(ACC_PRODUCT,$product,array(),0);	
				$count             = $this->input->post("count");
				for($i=1;$i<=$count;$i++)
				{
					$taxArray               = array(                    	
						"product_id"        => $prd_id,
						"tax_id"            => $this->input->post('tax_id'.$i),
						"tax_percent"       => $this->input->post('tax_name'.$i),
						"status"            => 0
					);
					$this->General_masters_model->save_data("acc_product_tax_details",$taxArray,array(),0);
				} 


				if ($this->db->trans_status() === FALSE)
				{												
					$this->session->set_flashdata('error', "An error occurred. Please try again later..!");
					$this->db->trans_rollback();
					$data['page_title'] 	 =	'Product';
					$data['page_name']  	 = 	'product/add_product';
					$data['page_master']	 = 	'Accounts Masters';
					$data['page_master_url'] = 	'General_masters/accProduct';
					$this->load->view('template/default', $data);
				}

				else{	
					$this->db->trans_complete();										
					$this->session->set_flashdata('msg', "Product Added Successfully..!");
					redirect('General_masters/accProduct');
				}


			}
			else
			{
				$this->form_validation->set_message('rule', 'Error Message');
			}
		}   
	
	$data['page_title'] 	=	'Product';
	$data['page_name']  	= 	'product/add_product';
	$data['page_master']	= 	'Accounts Masters';
	$data['page_master_url']= 	'General_masters/accProduct';
	$data['page_function']	=	'Add';
	$this->load->view('template/default', $data);

}

	public function get_taxclass()
	{
		$entered_str 	=	$this->input->get("q");
		$company_id 	=	$this->input->get("company_id");
		echo $this->General_masters_model->get_taxclass($entered_str,$company_id);
	}

	public function get_product_rule($update=0)
	{
		$config 	= array();
		$config []	= array(
		            'field'   => 'product_name', 
		            'label'   => 'Product Name', 
		            'rules'   => 'required'
		);


		$config []	= array(
		            'field'   => 'description', 
		            'label'   => 'Description', 
		            'rules'   => 'required'
		);

		return $config;
	}

	public function get_taxes(){
		$tax_class = $this->input->post('tax_class_id');
		$taxes     = $this->db->query("SELECT id,tax_name FROM acc_tax_master tm WHERE tm.tax_class = '$tax_class'")->result_array();
		echo json_encode($taxes);
}

  public function accProduct()
  {  

  		if(!$this->session->userdata('logged_in')) 
			redirect('Login');

		$url		=	'General_masters/accProduct';
		$order_field= 	'view';
		$join_array = 	array(0=>array(0=>USER_PERM_TBL,1=>"up_menu_id=menu_id",2=>''));
		$result 	=	$this->General_masters_model->select_data(MENU_TBL,'*',array("url"=>$url,"up_emp_id"=>$this->session->userdata('user_id')),'1',$join_array,$order_field,"DESC",'','',''); 

		if(empty($result))
		{ 
		
			$this->load->view('template/default');
		}
		else
		{	
			$condition 				=	array();
			
 		// 	if($this->input->get("product_id"))
			// {			
				// $condition 				=	array("id"	=>	$this->input->get("product_id"));
				$data['pdt_drpdwn'] =	$this->General_masters_model->select_data(ACC_PRODUCT,$select='id,product,description,price,hsn_sac',$condition, $by_row=0, array(),'product',"ASC",'', 0, null);

			//} 
		
							
	$data['table_rows']		=	$this->General_masters_model->get_productlist($this->input->get("consignee_id"));


	$data['page_title'] 	=	'Product';
	$data['page_name']  	= 	'product/product_lists';
	$data['page_master']	= 	'Accounts Masters';
	$data['page_master_url']= 	'General_masters/Ledger';
	$data['page_function']	=	'List';
	$this->load->view('template/default', $data);
}
}

	public function editProduct()
	{	
		if(!$this->session->userdata('logged_in')) 
			redirect('Login');

		$url		=	'General_masters/accProduct';
		$order_field= 	'edit';
		$join_array = 	array(0=>array(0=>USER_PERM_TBL,1=>"up_menu_id=menu_id",2=>'left'));
		$result 	=	$this->General_masters_model->select_data(MENU_TBL,'*',array("url"=>$url,"up_emp_id"=>$this->session->userdata('user_id')),'1',$join_array,$order_field,"DESC",'','','');
		
		if(empty($result))
		{			
			$this->load->view('template/default');
		}
		else
		{	
		
			$product_id 				=	$this->uri->segment(3);
			$data['product_id']			=	$product_id;						
			$data['edit_product']       = 	$this->General_masters_model->get_productlist($product_id);		
			$data['tax_name']			=   $this->General_masters_model->get_pdtTax($product_id);
			
	 		$data['page_title'] 	    =	'Product';
			$data['page_name']  	    = 	'product/edit_product';
			$data['page_master']	    = 	'General Masters';
			$data['page_master_url']    = 	'General_masters/accProduct';
			$data['page_function']	    =	'Edit';

		if ($this->input->post('submit'))
		{	 
	
			$this->form_validation->set_error_delimiters('<div style="color:red;text-align:center" class="error"><strong>', '</strong></div>');
			$this->form_validation->set_rules($this->get_product_rule(1));
			if ($this->form_validation->run('edit_product') == true) 
				{  
				
					$insert_array["product"] 		= $this->input->post("product_name");
					$insert_array["description"] 	= $this->input->post("description");
					$insert_array["price"] 			= $this->input->post("price");
					$insert_array["taxType"] 		= $this->input->post("tax_class_id");
					$insert_array["hsn_sac"] 		= $this->input->post("hsn"); 					
					$product_id 		            = $this->input->post("product_id");

					$this->General_masters_model->save_data(ACC_PRODUCT,$insert_array,array("id"=>$product_id),$product_id);

					$this->db->where('product_id',$product_id);	
					$this->db->update('acc_product_tax_details',array('status'=>1));
					
					$count           = $this->input->post("count");

					for($i=0;$i<=$count;$i++)
					{
						$taxArray                                 = array(                    	
							"product_id"                          => $product_id,
							"tax_id"                              => $this->input->post('tax_id'.$i),
							"tax_percent"                         => $this->input->post('tax_name'.$i),
							"status"                              => 0
						);
						$this->General_masters_model->save_data("acc_product_tax_details",$taxArray,array(),0);
					}

					$this->session->set_flashdata('msg', "Product Updated Successfully..!");
					redirect('General_masters/accProduct');					
				}
				else
				{
					$this->form_validation->set_message('rule', 'Error Message');
				}
			}
		}
		$this->load->view('template/default', $data);
	}


	public function add_customer()
	{		
		if(!$this->session->userdata('logged_in')) 
			redirect('Login');
		
		$url		=	'General_masters/customer';
		$order_field= 	'add';
		$join_array = 	array(0=>array(0=>USER_PERM_TBL,1=>"up_menu_id=menu_id",2=>''));
		$result 	=	$this->General_masters_model->select_data(MENU_TBL,'*',array("url"=>$url,"up_emp_id"=>$this->session->userdata('user_id')),'1',$join_array,$order_field,"DESC",'','','');
		if(empty($result))
		{
			 
			$this->load->view('template/default');
		}
		else
		{
			$date_format_text =array(0=>"dd/mm/yyyy",1=>"mm/dd/yyyy",2=>"yyyy/mm/dd",3=>"dd-mm-yyyy",4=>"mm-dd-yyyy",5=>"yyyy-mm-dd");
			if ($this->input->post('submit'))
			{	
													
				$this->form_validation->set_error_delimiters('<div style="color:red;text-align:center" class="error"><strong>', '</strong></div>');
				$this->form_validation->set_rules($this->get_customer_rule(0));
				if ($this->form_validation->run('add_customer') == true) 
				{
															
					$insert_array	=	array(	"customer_name"				    =>	$this->input->post("customer_name"),
												"customer_addr1"				=>	$this->input->post("customer_addr1"),
 												"customer_addr2"				=>	$this->input->post("customer_addr2"),
												"customer_addr3"				=>	$this->input->post("customer_addr3"),
 												"customer_addr4"				=>	$this->input->post("customer_addr4"),
												"customer_con_person" 			=>	$this->input->post("customer_con_person"),
												"customer_con_no"               =>  $this->input->post("customer_con_no"),
												"customer_alt_no"               =>  $this->input->post("customer_alt_no"),
												"customer_fax"                  =>  $this->input->post("customer_fax"),
												"pan_no"                  =>  $this->input->post("pan"),
												"gst"                  =>  $this->input->post("gst"),
												"iec"                  =>  $this->input->post("iec"),
												"state"                  =>  $this->input->post("state"),
												"customer_created_date"		    =>	date('Y-m-d H:i:s'),
											);

						$this->General_masters_model->save_data(CUSTOMER_TBL,$insert_array,array(),0);
						$this->session->set_flashdata('msg', "Customer Added Successfully..!");
						redirect('General_masters/customer');
						
					
				}
				else
				{
					$this->form_validation->set_message('rule', 'Error Message');
				}
			} 
			
						
				
			$data['recent_list'] 	=	$this->General_masters_model->get_consignor();
			$data['date_format_text']=	$date_format_text;
			$data['page_title'] 	=	'Customer';
		    $data['page_name']  	= 	'customer/add-customer';
		    $data['page_master']	= 	'General Masters';
		    $data['page_master_url'] = 	'General_masters/customer';
		    $data['page_function']	=	'Add';
		 	$this->load->view('template/default', $data);
		}
	}

	public function customer()	

	{  
		if(!$this->session->userdata('logged_in')) 
			redirect('Login');
		$url		=	'General_masters/customer';
		$order_field= 	'view';
		$join_array = 	array(0=>array(0=>USER_PERM_TBL,1=>"up_menu_id=menu_id",2=>''));
		$result 	=	$this->General_masters_model->select_data(MENU_TBL,'*',array("url"=>$url,"up_emp_id"=>$this->session->userdata('user_id')),'1',$join_array,$order_field,"DESC",'','',''); 
		if(empty($result))
		{ 
		
			$this->load->view('template/default');
		}
		else
		{	
			$condition 				     =	array();			
 			if($this->input->get("customer_id"))
			{
			
				$condition 				 =	array("customer_id"	=>	$this->input->get("customer_id"));
				$data['customer_drpdwn'] =	$this->General_masters_model->select_data(CUSTOMER_TBL,$select='customer_id,customer_name',$condition, $by_row=0, array(),'customer_name',"ASC",'', 0, null);
						
				 
			}
			$data['table_rows']		 =	$this->General_masters_model->get_customerlist($this->input->get("customer_id"));
			$data['page_title'] 	 =	'Customer';
		    $data['page_name']  	 = 	'customer/customer-list';
		    $data['page_master']	 = 	'General Masters';
		    $data['page_master_url'] = 	'General_masters/customer';
		    $data['page_function']	 =	'List';
			$this->load->view('template/default', $data);
		}
	}

	public function edit_customer()
	{	
		if(!$this->session->userdata('logged_in')) 
			redirect('Login');
		$url		=	'General_masters/customer';
		$order_field= 	'edit';
		$join_array = 	array(0=>array(0=>USER_PERM_TBL,1=>"up_menu_id=menu_id",2=>''));
		$result 	=	$this->General_masters_model->select_data(MENU_TBL,'*',array("url"=>$url,"up_emp_id"=>$this->session->userdata('user_id')),'1',$join_array,$order_field,"DESC",'','','');
		if(empty($result))
		{
			
			$this->load->view('template/default');
		}
		else
		{	
			 			
				
		    $customer_id 				=	$this->uri->segment(3);
			$data['customer_id']		=	$customer_id;						
			$data['edit_customer']      = 	$this->General_masters_model->select_data(CUSTOMER_TBL,'*',array("customer_id"=>$customer_id),1, array(),'customer_name',"ASC",'', '','');			
			$data['recent_list'] 	    =	$this->General_masters_model->get_consignee();		
			$customer_country_id 		=	$data['edit_customer']->customer_country_id;
			$customer_state_id 			=	$data['edit_customer']->customer_state_id;
			$data['country_drpdwn']     =	$this->General_masters_model->select_data(COUNTRY_TBL,$select='country_id,name',array("country_id"=>$customer_country_id), 0, array(),'sortname',"ASC",'', 0, null);
			$data['state_drpdwn']       =	$this->General_masters_model->select_data(STATE_TBL,$select='state_id,state',array("state_id"=>$customer_state_id),0, array(),'state',"ASC",'', 0, null); 
 			$data['page_title'] 	    =	'Customer';
		    $data['page_name']  	    = 	'customer/edit-customer';
		    $data['page_master']	    = 	'General Masters';
		    $data['page_master_url']    = 	'General_masters/customer';
		    $data['page_function']	    =	'Edit';

			if ($this->input->post('submit'))
			{	
	
				$this->form_validation->set_error_delimiters('<div style="color:red;text-align:center" class="error"><strong>', '</strong></div>');
				$this->form_validation->set_rules($this->get_customer_rule(1));
				if ($this->form_validation->run('edit_customer') == true) 
				{
				 
					$insert_array["customer_name"] 				    = $this->input->post("customer_name");
					$insert_array["customer_addr1"] 				= $this->input->post("customer_addr1");
					$insert_array["customer_addr2"] 				= $this->input->post("customer_addr2");
					$insert_array["customer_addr3"] 				= $this->input->post("customer_addr3");
					$insert_array["customer_addr4"] 				= $this->input->post("customer_addr4");
					$insert_array["customer_con_person"] 			= $this->input->post("customer_con_person");
					$insert_array["customer_con_no"] 				= $this->input->post("customer_con_no");
					$insert_array["customer_alt_no"] 				= $this->input->post("customer_alt_no");
					$insert_array["customer_fax"] 				    = $this->input->post("customer_fax");
					$insert_array["pan_no"] 				    = $this->input->post("pan");
					$insert_array["gst"] 				    = $this->input->post("gst");
					$insert_array["iec"] 				    = $this->input->post("iec");
					$insert_array["state"] 				    = $this->input->post("state");
					$insert_array["customer_created_date"] 		    = date('Y-m-d H:i:s');
					   					
					$customer_id 		=	$this->input->post("customer_id");
					$this->General_masters_model->save_data(CUSTOMER_TBL,$insert_array,array("customer_id"=>$customer_id),$customer_id);
					$this->session->set_flashdata('msg', "Customer Updated Successfully..!");
					redirect('General_masters/customer');					
				}
				else
				{
					$this->form_validation->set_message('rule', 'Error Message');
				}
			}
		}
		$this->load->view('template/default', $data);
	}
	public function prefix()
	{
		if(!$this->session->userdata('logged_in')) 
		redirect('Login');
		$url		=	'General_masters/prefix';
		$order_field= 	'view';
		$join_array = 	array(0=>array(0=>USER_PERM_TBL,1=>"up_menu_id=menu_id",2=>''));
		$result 	=	$this->General_masters_model->select_data(MENU_TBL,'*',array("url"=>$url,"up_emp_id"=>$this->session->userdata('user_id')),'1',$join_array,$order_field,"DESC",'','',''); 
		if(empty($result))
		{ 
		
			$this->load->view('template/default');
		}
		else
		{	
		
		
		
		$condition 				=	array();
		
		//$data['table_rows']=$this->General_masters_model->select_data(prefix_master,$select='current_no,prefix_name,starting_no,prefix_id',$condition, $by_row=0, array(),'prefix_id',"DESC",'', 0, null);
		
		$data['table_rows']=$this->General_masters_model->get_prefix();
		
		
		$data['branch_drpdwn']  =	$this->General_masters_model->select_data(prefix_master,$select='current_no,prefix_name,starting_no,prefix_id',array(), $by_row=0, array(),'prefix_name',"ASC",'', 0, null);
		
			$data['page_title'] 	=	'Prefix';
		    $data['page_name']  	= 	'prefix/prefix_list';
		    $data['page_master']	= 	'General Masters';
		    $data['page_master_url']= 	'General_masters/prefix';
		    $data['page_function']	=	'List';
			$this->load->view('template/default', $data);
		}
	}
	public function edit_prefix()
	{
	if(!$this->session->userdata('logged_in')) 
			redirect('Login');
		$url		=	'General_masters/prefix';
		$order_field= 	'edit';
		$join_array = 	array(0=>array(0=>USER_PERM_TBL,1=>"up_menu_id=menu_id",2=>''));
		$result 	=	$this->General_masters_model->select_data(MENU_TBL,'*',array("url"=>$url,"up_emp_id"=>$this->session->userdata('user_id')),'1',$join_array,$order_field,"DESC",'','','');
		if(empty($result))
		{
			
			$this->load->view('template/default');
		}
		else
		{	
			 			
				
		    $prefix_id 				=	$this->uri->segment(3);
			$data['customer_id']		=	$prefix_id;						
			$data['edit_customer']      = 	$this->General_masters_model->select_data(prefix_master,'*',array("prefix_id"=>$prefix_id),1, array(),'prefix_name',"ASC",'', '','');	
			$data['company_drpdwn']   =	$this->Invoice_model->select_data(COMPANY_TBL,$select='cmp_id,cmp_name',array(), $by_row=0, array(),'cmp_name',"ASC",'', 0, null);			
			$data['recent_list'] 	    =	$this->General_masters_model->get_prefix();		
			
 			$data['page_title'] 	    =	'Edit Prefix';
		    $data['page_name']  	    = 	'prefix/prefix_add';
		    $data['page_master']	    = 	'General Masters';
		    $data['page_master_url']    = 	'General_masters/edit_prefix';
		    $data['page_function']	    =	'Edit';

			if ($this->input->post('submit'))
			{	
	
				$this->form_validation->set_error_delimiters('<div style="color:red;text-align:center" class="error"><strong>', '</strong></div>');
				//$this->form_validation->set_rules($this->get_customer_rule(1));
				//if ($this->form_validation->run('edit_customer') == true) 
				//{
				 
					$insert_array["prefix_name"] 				    = $this->input->post("prefix");
					$insert_array["current_no"] 				= $this->input->post("current_no");
					
					
					   					
					$customer_id 		=	$this->input->post("customer_id");
					$this->General_masters_model->save_data(prefix_master,$insert_array,array("prefix_id"=>$customer_id),$customer_id);
					$this->session->set_flashdata('msg', "prefix Updated Successfully..!");
					redirect('General_masters/prefix');					
				//}
				//else
				//{
					//$this->form_validation->set_message('rule', 'Error Message');
				//}
			}
		}
		$this->load->view('template/default', $data);	
	}
   
}
?>